/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLblRefNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class ReplaceOldStyleDoLoopRefactoring
extends FortranEditorRefactoring {
    private List<ASTProperLoopConstructNode> loopList = new LinkedList<ASTProperLoopConstructNode>();
    private List<IActionStmt> lblList = new LinkedList<IActionStmt>();

    @Override
    public String getName() {
        return Messages.ReplaceOldStyleDoLoopRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.collectAllLoopsAndLabelsIn(this.astOfFileInEditor.getRoot());
        if (this.getOldStyleDoLoopCount() == 0) {
            this.fail(Messages.ReplaceOldStyleDoLoopRefactoring_ThereMustBeAtLeastOneOldStyleDoLoop);
        }
        for (ASTProperLoopConstructNode node : this.loopList) {
            IActionStmt labeledStmt;
            IASTNode loopBody;
            if (!this.isOldStyleDoLoop(node)) continue;
            ASTLabelDoStmtNode loopHeader = node.getLoopHeader();
            int labelCount = this.getCountForLabel(loopHeader.getLblRef().getLabel());
            String labelName = loopHeader.getLblRef().getLabel().getText();
            if (labelCount > 1) {
                this.fail(Messages.bind((String)Messages.ReplaceOldStyleDoLoopRefactoring_AmbiguousLabel, (Object)labelName));
            } else if (labelCount < 1) {
                this.fail(Messages.bind((String)Messages.ReplaceOldStyleDoLoopRefactoring_MissingLabel, (Object)labelName));
            }
            if (this.isSharedDoLoop(node) || (loopBody = (labeledStmt = this.getLabeledStatement(loopHeader.getLblRef().getLabel())).getParent()).getParent() == loopHeader.getParent()) continue;
            this.fail(Messages.bind((String)Messages.ReplaceOldStyleDoLoopRefactoring_EndOfLoopError, (Object)labelName));
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        for (ASTProperLoopConstructNode node : this.loopList) {
            if (!this.isOldStyleDoLoop(node)) continue;
            ASTEndDoStmtNode newNode = (ASTEndDoStmtNode)ReplaceOldStyleDoLoopRefactoring.parseLiteralStatement("END DO" + EOL);
            node.setEndDoStmt(newNode);
            node.getLoopHeader().setLblRef(null);
            Reindenter.reindent(node, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void collectAllLoopsAndLabelsIn(ScopingNode scope) {
        scope.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
                ReplaceOldStyleDoLoopRefactoring.this.loopList.add(0, node);
                this.traverseChildren(node);
            }

            @Override
            public void visitIActionStmt(IActionStmt node) {
                if (node.getLabel() != null) {
                    ReplaceOldStyleDoLoopRefactoring.this.lblList.add(0, node);
                }
                this.traverseChildren(node);
            }
        });
    }

    private boolean isSharedDoLoop(ASTProperLoopConstructNode node) {
        IASTNode parentNode = node.getParent();
        if (parentNode instanceof IASTListNode && parentNode.getParent() instanceof ASTProperLoopConstructNode) {
            if ((parentNode = parentNode.getParent()) instanceof ASTProperLoopConstructNode) {
                ASTLblRefNode aSTLblRefNode = node.getLoopHeader().getLblRef();
                if (aSTLblRefNode != null) {
                    Token headerNodeLabel = aSTLblRefNode.getLabel();
                    ASTLblRefNode parentNodeRefLbl = ((ASTProperLoopConstructNode)parentNode).getLoopHeader().getLblRef();
                    if (parentNodeRefLbl != null) {
                        Token parentNodeLabel = parentNodeRefLbl.getLabel();
                        return parentNodeLabel.getText().equals(headerNodeLabel.getText());
                    }
                    return false;
                }
                return false;
            }
        } else {
            for (IASTNode iASTNode : node.getBody()) {
                if (!(iASTNode instanceof ASTProperLoopConstructNode)) continue;
                ASTLblRefNode headerLabelRef = node.getLoopHeader().getLblRef();
                if (headerLabelRef != null) {
                    Token headerLabel = headerLabelRef.getLabel();
                    ASTLblRefNode childLabelRefNode = ((ASTProperLoopConstructNode)iASTNode).getLoopHeader().getLblRef();
                    if (childLabelRefNode != null) {
                        Token childLabel = childLabelRefNode.getLabel();
                        return childLabel.getText().equals(headerLabel.getText());
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    private int getOldStyleDoLoopCount() {
        int count = 0;
        for (ASTProperLoopConstructNode loopNode : this.loopList) {
            if (!this.isOldStyleDoLoop(loopNode)) continue;
            ++count;
        }
        return count;
    }

    private boolean isOldStyleDoLoop(ASTProperLoopConstructNode node) {
        return node.getEndDoStmt() == null && node.getLoopHeader().getLblRef() != null;
    }

    private int getCountForLabel(Token label) {
        int count = 0;
        for (IActionStmt node : this.lblList) {
            if (!label.getText().equals(node.getLabel().getText())) continue;
            ++count;
        }
        return count;
    }

    private IActionStmt getLabeledStatement(Token label) {
        for (IActionStmt node : this.lblList) {
            if (!label.getText().equals(node.getLabel().getText())) continue;
            return node;
        }
        return null;
    }
}

