/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class EISCompositeCollectionMapping
extends AbstractCompositeCollectionMapping
implements EISMapping {
    @Override
    public boolean isEISMapping() {
        return true;
    }

    @Override
    public void preInitialize(AbstractSession session) {
        super.preInitialize(session);
        if (((EISDescriptor)this.descriptor).isXMLFormat() && !(this.field instanceof XMLField)) {
            XMLField newField = new XMLField(this.field.getName());
            this.field = newField;
        }
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getContainerPolicy() instanceof MapContainerPolicy) {
            ((MapContainerPolicy)this.getContainerPolicy()).setElementClass(this.getReferenceClass());
        }
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public void setFieldName(String fieldName) {
        this.setField(new DatabaseField(fieldName));
    }

    @Override
    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, CacheKey parentsCacheKey, JoinedAttributeManager joinManager, AbstractSession targetSession) {
        if (((EISDescriptor)descriptor).isXMLFormat()) {
            return descriptor.getObjectBuilder().buildObject(query, nestedRow, joinManager);
        }
        Object element = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoObject(element, parentsCacheKey, nestedRow, query, joinManager, query.getExecutionFetchGroup(descriptor), false, targetSession);
        return element;
    }

    @Override
    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat()) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
            return objectBuilder.buildRow(attributeValue, session, this.getField(), (XMLRecord)parentRow);
        }
        return this.getObjectBuilder(attributeValue, session).buildRow(attributeValue, session, writeType);
    }
}

