/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public abstract class AbstractEvaluationVisitor
extends AbstractExtendingVisitor<Object, ExecutorInternal.ExecutorInternalExtension>
implements EvaluationVisitor.EvaluationVisitorExtension {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    @Deprecated
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull IdResolver idResolver;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    protected @NonNull EvaluationVisitor undecoratedVisitor;
    protected @Nullable Monitor monitor = null;
    @Deprecated
    protected final @NonNull EvaluationEnvironment evaluationEnvironment;
    @Deprecated
    protected final @NonNull CompleteEnvironmentInternal completeEnvironment;
    @Deprecated
    protected final @NonNull ModelManager modelManager;

    @Deprecated
    protected AbstractEvaluationVisitor(@NonNull EvaluationEnvironment evaluationEnvironment) {
        this(((EvaluationEnvironment.EvaluationEnvironmentExtension)evaluationEnvironment).getExecutor());
    }

    protected AbstractEvaluationVisitor(@NonNull ExecutorInternal executor) {
        super((ExecutorInternal.ExecutorInternalExtension)executor);
        this.environmentFactory = executor.getEnvironmentFactory();
        this.metamodelManager = this.environmentFactory.getMetamodelManager();
        this.idResolver = this.environmentFactory.getIdResolver();
        this.standardLibrary = this.environmentFactory.getStandardLibrary();
        this.undecoratedVisitor = this;
        this.evaluationEnvironment = executor.getRootEvaluationEnvironment();
        this.completeEnvironment = this.environmentFactory.getCompleteEnvironment();
        this.modelManager = executor.getModelManager();
    }

    @Deprecated
    protected @NonNull Map<String, Pattern> createRegexCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public @NonNull CompleteEnvironment getCompleteEnvironment() {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getCompleteEnvironment();
    }

    @Override
    @Deprecated
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getDiagnosticSeverity(severityPreference, resultValue);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    @Deprecated
    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getEvaluationEnvironment();
    }

    @Override
    public @NonNull EvaluationVisitor getEvaluator() {
        return this;
    }

    @Override
    public @NonNull ExecutorInternal getExecutor() {
        return (ExecutorInternal)this.context;
    }

    @Override
    @Deprecated
    public @NonNull IdResolver getIdResolver() {
        return this.idResolver;
    }

    @Override
    @Deprecated
    public @Nullable EvaluationLogger getLogger() {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getLogger();
    }

    @Override
    @Deprecated
    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return (PivotMetamodelManager)((ExecutorInternal.ExecutorInternalExtension)this.context).getMetamodelManager();
    }

    @Override
    @Deprecated
    public @NonNull ModelManager getModelManager() {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getModelManager();
    }

    @Override
    public @Nullable Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    @Deprecated
    public @NonNull Pattern getRegexPattern(@NonNull String regex) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getRegexPattern(regex);
    }

    @Override
    @Deprecated
    public int getSeverity(@Nullable Object validationKey) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getSeverity(validationKey);
    }

    @Override
    @Deprecated
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @Deprecated
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getStaticTypeOf(value);
    }

    @Override
    @Deprecated
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getStaticTypeOf(value, values);
    }

    @Override
    @Deprecated
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return ((ExecutorInternal.ExecutorInternalExtension)this.context).getStaticTypeOf(value, values);
    }

    protected final @NonNull EvaluationVisitor getUndecoratedVisitor() {
        return this.undecoratedVisitor;
    }

    @Override
    public boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        if (this.monitor != null) {
            this.monitor.setCanceled(isCanceled);
        } else if (isCanceled) {
            this.monitor = new BasicMonitor();
            this.monitor.setCanceled(isCanceled);
        }
    }

    @Override
    @Deprecated
    public void setLogger(@Nullable EvaluationLogger logger) {
        ((ExecutorInternal.ExecutorInternalExtension)this.context).setLogger(logger);
    }

    @Override
    public void setMonitor(@Nullable Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void setUndecoratedVisitor(@NonNull EvaluationVisitor evaluationVisitor) {
        this.undecoratedVisitor = evaluationVisitor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    @Override
    public @Nullable Object visit(@NonNull Visitable visitable) {
        return visitable.accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitConstraint(@NonNull Constraint constraint) {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (!(specification instanceof ExpressionInOCL)) {
            return null;
        }
        OCLExpression body = ((ExpressionInOCL)specification).getOwnedBody();
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        Object result = body.accept(this.undecoratedVisitor);
        return ValueUtil.asBoolean(result);
    }
}

