/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class EditUIUtil {
    public static URI getURI(IEditorInput editorInput) {
        URI result = null;
        result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(String fileName) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName)) : null;
    }

    public static IEditorDescriptor getDefaultEditor(InputStream contents, String fileName) {
        if (contents != null) {
            try {
                return EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName));
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getDefaultEditor(fileName);
    }

    private static IEditorDescriptor getDefaultEditor(String fileName, IContentType[] contentTypes) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getDefaultEditor(fileName, null);
        }
        IEditorDescriptor result = null;
        int i = 0;
        while (result == null && i < contentTypes.length) {
            result = editorRegistry.getDefaultEditor(fileName, contentTypes[i]);
            ++i;
        }
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(URI uri, URIConverter uriConverter) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(stream, fileName);
            return iEditorDescriptor;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(fileName);
            return iEditorDescriptor;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
    }

    public static IEditorDescriptor[] getEditors(String fileName, boolean defaultsOnly) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName), defaultsOnly) : new IEditorDescriptor[]{};
    }

    public static IEditorDescriptor[] getEditors(InputStream contents, String fileName, boolean defaultsOnly) {
        if (contents != null) {
            try {
                return EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName), defaultsOnly);
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getEditors(fileName, defaultsOnly);
    }

    private static IEditorDescriptor[] getEditors(String fileName, IContentType[] contentTypes, boolean defaultsOnly) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getEditors(fileName, null);
        }
        UniqueEList result = new UniqueEList();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (defaultsOnly) {
                IEditorDescriptor editor = editorRegistry.getDefaultEditor(fileName, contentType);
                if (editor != null) {
                    result.add(editor);
                }
            } else {
                result.addAll(Arrays.asList(editorRegistry.getEditors(fileName, contentType)));
            }
            ++n2;
        }
        return result.toArray(new IEditorDescriptor[result.size()]);
    }

    public static IEditorDescriptor[] getEditors(URI uri, URIConverter uriConverter, boolean defaultsOnly) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(stream, fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }
}

