/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplicationEditor
extends AbstractComponentEditor<MApplication> {
    private Composite composite;
    private EMFDataBindingContext context;
    @Inject
    @Optional
    private IProject project;
    private final List<Action> actions = new ArrayList<Action>();

    @Inject
    public ApplicationEditor() {
    }

    @PostConstruct
    void init() {
    }

    @Override
    public List<Action> getActions(Object element) {
        return this.actions;
    }

    void doCreateCommandWizard() {
        WizardDialog dialog = new WizardDialog(this.composite.getShell(), (IWizard)new CommandWizard((MApplication)this.getMaster().getValue()));
        dialog.open();
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Application");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.ApplicationEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.ApplicationEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context);
        }
        this.getMaster().setValue((Object)((MApplication)object));
        return this.composite;
    }

    protected Composite createForm(Composite parent, EMFDataBindingContext context) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        ControlFactory.createBindingContextWiget(parent, this.Messages, this, this.Messages.ApplicationEditor_BindingContexts);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Context_Properties, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__PROPERTIES, 10);
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_Context_Variables, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__VARIABLES, 10);
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.AddonsEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MApplication.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        WritableList list = new WritableList();
        MApplication application = (MApplication)element;
        list.add(new VirtualEntry<MApplication, MAddon>("org.eclipse.e4.tools.emf.ui.VIRTUAL_ADDONS", E4Properties.addons(), application, this.Messages.ApplicationEditor_Addons));
        list.add(new VirtualEntry<MApplication, MBindingContext>("org.eclipse.e4.tools.emf.ui.VIRTUAL_ROOT_CONTEXTS", E4Properties.rootContext(), application, this.Messages.ApplicationEditor_RootContexts));
        list.add(new VirtualEntry<MApplication, MBindingTable>("org.eclipse.e4.tools.emf.ui.VIRTUAL_BINDING_TABLE", E4Properties.bindingTables(), application, this.Messages.ApplicationEditor_BindingTables));
        list.add(new VirtualEntry<MApplication, MHandler>("org.eclipse.e4.tools.emf.ui.VIRTUAL_HANDLER", E4Properties.handlers(), application, this.Messages.ApplicationEditor_Handlers));
        list.add(new VirtualEntry<MApplication, MCommand>("org.eclipse.e4.tools.emf.ui.VIRTUAL_COMMAND", E4Properties.applicationCommands(), application, this.Messages.ApplicationEditor_Commands));
        list.add(new VirtualEntry<MApplication, MCategory>("org.eclipse.e4.tools.emf.ui.VIRTUAL_CATEGORIES", E4Properties.categories(), application, this.Messages.ApplicationEditor_Categories));
        list.add(new VirtualEntry("org.eclipse.e4.tools.emf.ui.VIRTUAL_APPLICATION_WINDOWS", E4Properties.children(), application, this.Messages.ApplicationEditor_Windows));
        list.add(new VirtualEntry<MApplication, MPartDescriptor>("org.eclipse.e4.tools.emf.ui.VIRTUAL_PART_DESCRIPTORS", E4Properties.descriptors(), application, this.Messages.ApplicationEditor_PartDescriptors));
        list.add(new VirtualEntry<MApplication, MMenuContribution>("org.eclipse.e4.tools.emf.ui.VIRTUAL_MENU_CONTRIBUTIONS", E4Properties.menuContributions(), application, this.Messages.ApplicationEditor_MenuContributions));
        list.add(new VirtualEntry<MApplication, MToolBarContribution>("org.eclipse.e4.tools.emf.ui.VIRTUAL_TOOLBAR_CONTRIBUTIONS", E4Properties.toolBarContributions(), application, this.Messages.ApplicationEditor_ToolBarContributions));
        list.add(new VirtualEntry<MApplication, MTrimContribution>("org.eclipse.e4.tools.emf.ui.VIRTUAL_TRIM_CONTRIBUTIONS", E4Properties.trimContributions(), application, this.Messages.ApplicationEditor_TrimContributions));
        list.add(new VirtualEntry<MApplication, MUIElement>("org.eclipse.e4.tools.emf.ui.VIRTUAL_SNIPPETS", E4Properties.snippets(), application, this.Messages.ApplicationEditor_Snippets));
        return list;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    class CommandWizard
    extends Wizard {
        private final MApplication application;
        private HandlerCommandPage handlerPage;
        private KeybindingPage keyPage;
        private MenuWizardPage menuPage;
        private ToolbarWizardPage toolbarPage;

        public CommandWizard(MApplication application) {
            this.application = application;
        }

        public void addPages() {
            this.getShell().setText(((ApplicationEditor)ApplicationEditor.this).Messages.CommandWizard_ShellTitle);
            this.setDefaultPageImageDescriptor(ImageDescriptor.createFromImage((Image)ApplicationEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.wizban.newexp_wiz")));
            this.handlerPage = new HandlerCommandPage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_HandlerAndCommand);
            this.addPage((IWizardPage)this.handlerPage);
            this.keyPage = new KeybindingPage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Keybinding, this.application);
            this.addPage((IWizardPage)this.keyPage);
            this.menuPage = new MenuWizardPage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Menu, this.application);
            this.addPage((IWizardPage)this.menuPage);
            this.toolbarPage = new ToolbarWizardPage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Toolbar, this.application);
            this.addPage((IWizardPage)this.toolbarPage);
        }

        public boolean performFinish() {
            String prefix;
            MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
            MHandler handler = CommandsFactoryImpl.eINSTANCE.createHandler();
            MKeyBinding keyBinding = null;
            String parentId = this.application.getElementId();
            String string = prefix = parentId != null && parentId.trim().length() > 0 ? parentId + "." : "";
            if (this.handlerPage.idField.getText().trim().length() > 0) {
                command.setElementId(prefix + "commands." + this.handlerPage.idField.getText().trim());
                handler.setElementId(prefix + "handlers." + this.handlerPage.idField.getText().trim());
            }
            if (this.application.getBindingTables().size() != 0 && this.keyPage.keyField.getText().trim().length() > 0 && !this.keyPage.bindtableViewer.getSelection().isEmpty()) {
                keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
                keyBinding.setKeySequence(this.keyPage.keyField.getText().trim());
                keyBinding.setCommand(command);
            }
            command.setCommandName(this.handlerPage.nameField.getText());
            handler.setCommand(command);
            CompoundCommand cmd = new CompoundCommand();
            cmd.append(AddCommand.create((EditingDomain)ApplicationEditor.this.getEditingDomain(), (Object)this.application, (Object)ApplicationPackageImpl.Literals.APPLICATION__COMMANDS, (Object)command));
            cmd.append(AddCommand.create((EditingDomain)ApplicationEditor.this.getEditingDomain(), (Object)this.application, (Object)CommandsPackageImpl.Literals.HANDLER_CONTAINER__HANDLERS, (Object)handler));
            if (keyBinding != null) {
                cmd.append(AddCommand.create((EditingDomain)ApplicationEditor.this.getEditingDomain(), (Object)((IStructuredSelection)this.keyPage.bindtableViewer.getSelection()).getFirstElement(), (Object)CommandsPackageImpl.Literals.BINDING_TABLE__BINDINGS, (Object)keyBinding));
            }
            if (cmd.canExecute()) {
                ApplicationEditor.this.getEditingDomain().getCommandStack().execute((Command)cmd);
                return true;
            }
            return false;
        }
    }

    class HandlerCommandPage
    extends WizardPage {
        public Text idField;
        public Text nameField;

        public HandlerCommandPage(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            this.setTitle(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Command_Slash_Handler);
            this.setMessage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_InsertInfosForCommandAndHandler);
            Composite group = new Composite(parent, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(3, false));
            Label l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Id);
            this.idField = new Text(group, 2048);
            this.idField.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Name + "*");
            this.nameField = new Text(group, 2048);
            this.nameField.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
            this.nameField.addModifyListener(e -> this.setPageComplete(this.nameField.getText().trim().length() > 0));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Class);
            Text t = new Text(group, 2048);
            t.setLayoutData((Object)new GridData(768));
            ControlFactory.createFindButton(group, ApplicationEditor.this.resourcePool);
            this.setControl((Control)group);
        }

        public boolean isPageComplete() {
            return this.nameField.getText().trim().length() > 0;
        }
    }

    class HiearchyLabelProvider
    extends StyledCellLabelProvider {
        HiearchyLabelProvider() {
        }

        public void update(ViewerCell cell) {
            EObject o = (EObject)cell.getElement();
            String label = "";
            Image img = null;
            AbstractComponentEditor<?> elementEditor = ApplicationEditor.this.getEditor().getEditor(o.eClass());
            if (elementEditor != null) {
                label = elementEditor.getDetailLabel(o);
                label = label == null ? elementEditor.getLabel(o) : label;
                img = elementEditor.getImage(o);
            }
            ArrayList<String> parentPath = new ArrayList<String>();
            while (o.eContainer() != null) {
                o = o.eContainer();
                elementEditor = ApplicationEditor.this.getEditor().getEditor(o.eClass());
                if (elementEditor == null) continue;
                parentPath.add(0, elementEditor.getLabel(o));
            }
            Object parentString = "";
            for (String p : parentPath) {
                parentString = (String)parentString + "/" + p;
            }
            StyledString s = new StyledString(label);
            s.append(" - " + (String)parentString, StyledString.DECORATIONS_STYLER);
            cell.setStyleRanges(s.getStyleRanges());
            cell.setText(s.getString());
            cell.setImage(img);
        }
    }

    class KeybindingPage
    extends WizardPage {
        private Text keyField;
        private TableViewer bindtableViewer;
        private final MApplication application;

        public KeybindingPage(String pageName, MApplication application) {
            super(pageName);
            this.application = application;
        }

        public void createControl(Composite parent) {
            this.setTitle(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Keybinding);
            this.setMessage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_InsertInfosForKeybinding);
            Composite group = new Composite(parent, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Sequence);
            this.keyField = new Text(group, 2048);
            this.keyField.setLayoutData((Object)new GridData(768));
            this.keyField.addModifyListener(e -> {
                this.bindtableViewer.getControl().setEnabled(this.isPageComplete());
                this.setPageComplete(this.isPageComplete());
            });
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_BindingTable);
            l.setLayoutData((Object)new GridData(2));
            this.bindtableViewer = new TableViewer(group);
            FontDescriptor italicFontDescriptor = FontDescriptor.createFrom((Font)this.bindtableViewer.getControl().getFont()).setStyle(2);
            this.bindtableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ComponentLabelProvider(ApplicationEditor.this.getEditor(), ApplicationEditor.this.Messages, italicFontDescriptor)));
            this.bindtableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.bindtableViewer.setInput((Object)this.application.getBindingTables());
            this.bindtableViewer.addSelectionChangedListener(event -> this.setPageComplete(this.isPageComplete()));
            this.bindtableViewer.setSelection((ISelection)new StructuredSelection(this.application.getBindingTables().get(0)));
            GridData gd = new GridData(1808);
            gd.heightHint = this.bindtableViewer.getTable().getItemHeight() * 5;
            this.bindtableViewer.getControl().setLayoutData((Object)gd);
            this.bindtableViewer.getControl().setEnabled(false);
            this.setControl((Control)group);
        }

        public boolean isPageComplete() {
            if (this.keyField.getText().trim().length() == 0) {
                return true;
            }
            return !this.bindtableViewer.getSelection().isEmpty();
        }
    }

    class MenuWizardPage
    extends WizardPage {
        private final MApplication application;
        private Text labelField;
        private Text iconField;
        private ComboViewer typeViewer;
        private TableViewer menuViewer;

        public MenuWizardPage(String pageName, MApplication application) {
            super(pageName);
            this.application = application;
        }

        public void createControl(Composite parent) {
            this.setTitle(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_HandledMenuItem);
            this.setMessage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_InertInfosForAHandledMenuItem);
            Composite group = new Composite(parent, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            Label l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Label);
            this.labelField = new Text(group, 2048);
            this.labelField.setLayoutData((Object)new GridData(768));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Icon);
            this.iconField = new Text(group, 2048);
            this.iconField.setLayoutData((Object)new GridData(768));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Type);
            this.typeViewer = new ComboViewer(group, 8);
            this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.typeViewer.setInput((Object)ItemType.values());
            this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)ItemType.PUSH));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Parent);
            l.setLayoutData((Object)new GridData(2));
            this.menuViewer = new TableViewer(group);
            this.menuViewer.setLabelProvider((IBaseLabelProvider)new HiearchyLabelProvider());
            this.menuViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ArrayList<MMenu> menuList = new ArrayList<MMenu>();
            TreeIterator it = EcoreUtil.getAllContents(Collections.singleton(this.application));
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!MenuPackageImpl.Literals.MENU.isSuperTypeOf(o.eClass())) continue;
                menuList.add((MMenu)o);
            }
            this.menuViewer.setInput(menuList);
            this.menuViewer.addSelectionChangedListener(event -> this.setPageComplete(this.isPageComplete()));
            GridData gd = new GridData(1808);
            gd.heightHint = this.menuViewer.getTable().getItemHeight() * 5;
            this.menuViewer.getControl().setLayoutData((Object)gd);
            this.menuViewer.setSelection((ISelection)new StructuredSelection(menuList.get(0)));
            this.setControl((Control)group);
        }

        public boolean isPageComplete() {
            if (this.labelField.getText().trim().length() == 0 && this.iconField.getText().trim().length() == 0) {
                return true;
            }
            return !this.menuViewer.getSelection().isEmpty();
        }
    }

    class ToolbarWizardPage
    extends WizardPage {
        private final MApplication application;
        private Text labelField;
        private Text iconField;
        private ComboViewer typeViewer;
        private TableViewer toolbarViewer;

        public ToolbarWizardPage(String pageName, MApplication application) {
            super(pageName);
            this.application = application;
        }

        public void createControl(Composite parent) {
            this.setTitle(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_HandledToolbarItem);
            this.setMessage(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_InsertInfosForAToolbarItem);
            Composite group = new Composite(parent, 0);
            group.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            group.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Label);
            this.labelField = new Text(group, 2048);
            this.labelField.setLayoutData((Object)new GridData(768));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Icon);
            this.iconField = new Text(group, 2048);
            this.iconField.setLayoutData((Object)new GridData(768));
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Type);
            this.typeViewer = new ComboViewer(group, 8);
            this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.typeViewer.setInput((Object)ItemType.values());
            l = new Label(group, 0);
            l.setText(((ApplicationEditor)ApplicationEditor.this).Messages.ApplicationEditor_Parent);
            l.setLayoutData((Object)new GridData(2));
            this.toolbarViewer = new TableViewer(group);
            this.toolbarViewer.setLabelProvider((IBaseLabelProvider)new HiearchyLabelProvider());
            this.toolbarViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ArrayList<MToolBar> toolbarList = new ArrayList<MToolBar>();
            TreeIterator it = EcoreUtil.getAllContents(Collections.singleton(this.application));
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!MenuPackageImpl.Literals.TOOL_BAR.isSuperTypeOf(o.eClass())) continue;
                toolbarList.add((MToolBar)o);
            }
            this.toolbarViewer.setInput(toolbarList);
            this.toolbarViewer.addSelectionChangedListener(event -> this.setPageComplete(this.isPageComplete()));
            GridData gd = new GridData(1808);
            gd.heightHint = this.toolbarViewer.getTable().getItemHeight() * 5;
            this.toolbarViewer.getControl().setLayoutData((Object)gd);
            this.toolbarViewer.setSelection((ISelection)new StructuredSelection(toolbarList.get(0)));
            this.setControl((Control)group);
        }

        public boolean isPageComplete() {
            if (this.labelField.getText().trim().length() == 0 && this.iconField.getText().trim().length() == 0) {
                return true;
            }
            return !this.toolbarViewer.getSelection().isEmpty();
        }
    }
}

