/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.binding;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.dom.binding.ClassDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.FunctionDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.NodeUtil;
import org.eclipse.wst.jsdt.internal.core.dom.binding.VariableDeclaration;

public class Scope {
    private static final String ARGUMENTS = "arguments";
    private final Map<String, IDeclaration> declarations = new LinkedHashMap<String, IDeclaration>();
    private final Scope parent;
    protected final int depth;
    protected final ASTNode rootNode;
    private VariableDeclaration arguments;
    private int referenceCount = 0;

    Scope(Scope parent, ASTNode rootNode) {
        this.parent = parent;
        this.rootNode = rootNode;
        this.depth = parent == null ? 0 : parent.depth + 1;
    }

    public int getDepth() {
        return this.depth;
    }

    public ASTNode getRootNode() {
        return this.rootNode;
    }

    public Scope getParentScope() {
        return this.parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public Collection<IDeclaration> getDeclarations() {
        return this.declarations.values();
    }

    public Scope getGlobalScope() {
        Scope result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    IDeclaration declareVariable(String name, SimpleName node, VariableDeclaration.VariableKind varKind) {
        VariableDeclaration declaration = new VariableDeclaration(node, this, this.registerReference(), varKind);
        this.declarations.put(name, declaration);
        return declaration;
    }

    IDeclaration declareFunction(String name, SimpleName node) {
        FunctionDeclaration declaration = new FunctionDeclaration(node, this, this.registerReference());
        this.declarations.put(name, declaration);
        return declaration;
    }

    IDeclaration declareClass(String name, SimpleName node) {
        ClassDeclaration declaration = new ClassDeclaration(node, this, this.registerReference());
        this.declarations.put(name, declaration);
        return declaration;
    }

    public IDeclaration getOwnDeclaration(String name) {
        return this.declarations.get(name);
    }

    public IDeclaration getDeclaration(String name) {
        Scope scope = this;
        while (scope != null) {
            boolean plain;
            IDeclaration var = scope.declarations.get(name);
            if (var != null) {
                return var;
            }
            boolean bl = plain = (scope.isFunctionScope() || scope.isFunctionBlockScope()) && !scope.isArrowFunctionScope();
            if (ARGUMENTS.equals(name) && plain) {
                return scope.getArgumentsVariable();
            }
            scope = scope.parent;
        }
        return null;
    }

    public VariableDeclaration getArgumentsVariable() {
        if (this.arguments == null) {
            this.arguments = VariableDeclaration.createArgumentsDeclaration(this);
        }
        return this.arguments;
    }

    public boolean isDeclared(String name, boolean recurse) {
        Scope scope = this;
        while (true) {
            if (scope.declarations.containsKey(name)) {
                return true;
            }
            if (!scope.isFunctionBlockScope() && (scope.parent == null || !recurse)) break;
            scope = scope.parent;
        }
        return false;
    }

    public int getDeclarationsCount() {
        return this.declarations.size();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return this.parent != null;
    }

    public boolean isBlockScope() {
        switch (this.getRootNode().getNodeType()) {
            case 8: {
                return this.getRootNode().getParent() != null && this.getRootNode().getParent().getParent() != null && this.getRootNode().getParent().getNodeType() != 12;
            }
            case 24: 
            case 50: 
            case 55: 
            case 83: 
            case 96: {
                return true;
            }
        }
        return false;
    }

    public boolean isFunctionBlockScope() {
        return this.isBlockScope() && this.parent != null && (this.parent.getRootNode().getNodeType() == 109 || this.parent.getRootNode().getNodeType() == 31);
    }

    public boolean isFunctionScope() {
        return this.getRootNode().getNodeType() == 31;
    }

    public boolean isArrowFunctionScope() {
        ASTNode grandparent = NodeUtil.grandParent(this.getRootNode());
        return grandparent != null && grandparent.getNodeType() == 94;
    }

    public Scope getHoistScope() {
        Scope current = this;
        while (current != null) {
            if (current.isFunctionScope() || current.isFunctionBlockScope() || current.isGlobal()) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }

    public ASTNode getFunctionDeclarationLocation() {
        Scope current = this;
        while (current != null) {
            if (current.getRootNode().getNodeType() == 109) {
                org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = ((FunctionDeclarationStatement)current.getRootNode()).getDeclaration();
                return fd.getMethodName();
            }
            if (current.getRootNode().getNodeType() == 31) {
                org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = (org.eclipse.wst.jsdt.core.dom.FunctionDeclaration)current.getRootNode();
                return fd.getMethodName();
            }
            if (current.getRootNode().getNodeType() == 84) {
                org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = ((FunctionExpression)current.getRootNode()).getMethod();
                return fd.getMethodName();
            }
            current = current.parent;
        }
        return null;
    }

    public ASTNode getClassDeclarationLocation() {
        Scope current = this;
        while (current != null) {
            switch (current.getRootNode().getNodeType()) {
                case 56: {
                    TypeDeclaration td = (TypeDeclaration)((TypeDeclarationStatement)current.getRootNode()).getDeclaration();
                    return td.getName();
                }
                case 108: {
                    TypeDeclaration td = (TypeDeclaration)((TypeDeclarationExpression)current.getRootNode()).getDeclaration();
                    return td.getName();
                }
            }
            current = current.parent;
        }
        return null;
    }

    public String getKey() {
        Stack<String> scopes = new Stack<String>();
        Scope current = this;
        while (current != null) {
            switch (current.getRootNode().getNodeType()) {
                case 56: {
                    TypeDeclaration td = (TypeDeclaration)((TypeDeclarationStatement)current.getRootNode()).getDeclaration();
                    scopes.push(td.getName().getIdentifier());
                    break;
                }
                case 108: {
                    TypeDeclaration td = (TypeDeclaration)((TypeDeclarationExpression)current.getRootNode()).getDeclaration();
                    scopes.push(td.getName().getIdentifier());
                    break;
                }
                case 109: {
                    org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = ((FunctionDeclarationStatement)current.getRootNode()).getDeclaration();
                    SimpleName fname = (SimpleName)fd.getMethodName();
                    if (fname != null) {
                        scopes.push(fname.getIdentifier());
                        break;
                    }
                    scopes.push("@");
                    break;
                }
                case 31: {
                    org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = (org.eclipse.wst.jsdt.core.dom.FunctionDeclaration)current.getRootNode();
                    SimpleName fname = (SimpleName)fd.getMethodName();
                    if (fname != null) {
                        scopes.push(fname.getIdentifier());
                        break;
                    }
                    scopes.push("@");
                    break;
                }
                case 84: {
                    org.eclipse.wst.jsdt.core.dom.FunctionDeclaration fd = ((FunctionExpression)current.getRootNode()).getMethod();
                    SimpleName fname = (SimpleName)fd.getMethodName();
                    if (fname != null) {
                        scopes.push(fname.getIdentifier());
                        break;
                    }
                    scopes.push("@");
                    break;
                }
                case 8: {
                    if (current.getRootNode().getParent() == null || current.getRootNode().getParent().getNodeType() != 31) break;
                    scopes.push("*");
                }
            }
            current = current.parent;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        while (!scopes.isEmpty()) {
            sb.append((String)scopes.pop());
            sb.append("/");
        }
        return sb.toString();
    }

    public int registerReference() {
        return this.referenceCount++;
    }
}

