/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.internal.jvm.JVMChannel;
import org.eclipse.net4j.internal.jvm.bundle.OM;
import org.eclipse.net4j.internal.jvm.messages.Messages;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

public abstract class JVMConnector
extends Connector
implements IJVMConnector,
InternalChannelMultiplexer.BufferMultiplexer {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, JVMConnector.class);
    private JVMConnector peer;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JVMConnector getPeer() {
        return this.peer;
    }

    public void setPeer(JVMConnector peer) {
        this.peer = peer;
    }

    public String getURL() {
        return "jvm://" + this.name;
    }

    public void multiplexBuffer(InternalChannel channel, IBuffer buffer) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Multiplexing " + buffer.formatContent(true));
        }
        buffer.flip();
        JVMChannel peerChannel = ((JVMChannel)channel).getPeer();
        peerChannel.handleBufferFromMultiplexer(buffer);
    }

    public void multiplexChannel(InternalChannel localChannel) {
        throw new UnsupportedOperationException();
    }

    protected INegotiationContext createNegotiationContext() {
        throw new UnsupportedOperationException();
    }

    protected InternalChannel createChannel() {
        return new JVMChannel();
    }

    protected void registerChannelWithPeer(short channelID, long timeoutIgnored, IProtocol<?> protocol) throws ChannelException {
        try {
            String protocolID = Net4jUtil.getProtocolID(protocol);
            int protocolVersion = Net4jUtil.getProtocolVersion(protocol);
            JVMChannel peerChannel = (JVMChannel)this.peer.inverseOpenChannel(channelID, protocolID, protocolVersion);
            if (peerChannel == null) {
                throw new ChannelException(Messages.getString("JVMConnector.2"));
            }
            JVMChannel c = (JVMChannel)this.getChannel(channelID);
            c.setPeer(peerChannel);
            peerChannel.setPeer(c);
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ChannelException((Throwable)ex);
        }
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        try {
            this.getPeer().inverseCloseChannel(channel.getID());
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ChannelException((Throwable)ex);
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.name, "name");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }
}

