/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IStackElement;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult2;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.Injection;
import org.eclipse.tm4e.core.internal.grammar.LineTokenizer;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.RawRepository;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.grammar.ScopeDependencyProcessor;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadataProvider;
import org.eclipse.tm4e.core.internal.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.StackElementMetadata;
import org.eclipse.tm4e.core.internal.grammar.TokenTypeMatcher;
import org.eclipse.tm4e.core.internal.grammar.TokenizeLineResult;
import org.eclipse.tm4e.core.internal.grammar.TokenizeLineResult2;
import org.eclipse.tm4e.core.internal.matcher.Matcher;
import org.eclipse.tm4e.core.internal.matcher.MatcherWithPriority;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleFactory;
import org.eclipse.tm4e.core.internal.theme.IThemeProvider;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class Grammar
implements IGrammar,
IRuleFactoryHelper {
    private static final System.Logger LOGGER = System.getLogger(Grammar.class.getName());
    private final String scopeName;
    private int rootId = -1;
    private int lastRuleId = 0;
    private final Map<Integer, @Nullable Rule> ruleId2desc = new HashMap<Integer, Rule>();
    private final Map<String, IRawGrammar> includedGrammars = new HashMap<String, IRawGrammar>();
    private final IGrammarRepository grammarRepository;
    private final IRawGrammar grammar;
    private @Nullable List<Injection> injections;
    private final ScopeMetadataProvider scopeMetadataProvider;
    private final List<TokenTypeMatcher> tokenTypeMatchers = new ArrayList<TokenTypeMatcher>();
    private final @Nullable BalancedBracketSelectors balancedBracketSelectors;

    public Grammar(String scopeName, IRawGrammar grammar, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors, IGrammarRepository grammarRepository, IThemeProvider themeProvider) {
        this.scopeName = scopeName;
        this.scopeMetadataProvider = new ScopeMetadataProvider(initialLanguage, themeProvider, embeddedLanguages);
        this.balancedBracketSelectors = balancedBracketSelectors;
        this.grammarRepository = grammarRepository;
        this.grammar = this.initGrammar(grammar, null);
        if (tokenTypes != null) {
            for (Map.Entry<String, Integer> entry : tokenTypes.entrySet()) {
                String selector = entry.getKey();
                final int type = entry.getValue();
                for (final MatcherWithPriority<List<String>> matcher : Matcher.createMatchers(selector)) {
                    this.tokenTypeMatchers.add(new TokenTypeMatcher(){

                        @Override
                        public int getType() {
                            return type;
                        }

                        @Override
                        public Matcher<List<String>> getMatcher() {
                            return matcher.matcher;
                        }
                    });
                }
            }
        }
    }

    public void onDidChangeTheme() {
        this.scopeMetadataProvider.onDidChangeTheme();
    }

    ScopeMetadata getMetadataForScope(String scope) {
        return this.scopeMetadataProvider.getMetadataForScope(scope);
    }

    private void collectInjections(List<Injection> result, String selector, IRawRule rule, IRuleFactoryHelper ruleFactoryHelper, IRawGrammar grammar) {
        List<MatcherWithPriority<List<String>>> matchers = Matcher.createMatchers(selector);
        int ruleId = RuleFactory.getCompiledRuleId(rule, ruleFactoryHelper, this.grammar.getRepository());
        for (MatcherWithPriority<List<String>> matcher : matchers) {
            result.add(new Injection(selector, matcher.matcher, ruleId, grammar, matcher.priority));
        }
    }

    private List<Injection> collectInjections() {
        IGrammarRepository grammarRepository = new IGrammarRepository(){

            @Override
            public @Nullable IRawGrammar lookup(String scopeName) {
                if (Objects.equals(scopeName, Grammar.this.scopeName)) {
                    return Grammar.this.grammar;
                }
                return Grammar.this.getExternalGrammar(scopeName, null);
            }

            @Override
            public @Nullable Collection<String> injections(String targetScope) {
                return Grammar.this.grammarRepository.injections(targetScope);
            }
        };
        ScopeDependencyProcessor dependencyProcessor = new ScopeDependencyProcessor(grammarRepository, this.scopeName);
        ArrayList<Injection> result = new ArrayList<Injection>();
        dependencyProcessor.seenFullScopeRequests.forEach(arg_0 -> this.lambda$0(grammarRepository, result, arg_0));
        Collections.sort(result, (i1, i2) -> i1.priority - i2.priority);
        return result;
    }

    List<Injection> getInjections() {
        List<Injection> injections = this.injections;
        if (injections == null) {
            injections = this.injections = this.collectInjections();
            if (LOGGER.isLoggable(System.Logger.Level.TRACE) && !injections.isEmpty()) {
                LOGGER.log(System.Logger.Level.TRACE, "Grammar " + this.scopeName + " contains the following injections:");
                for (Injection injection : injections) {
                    LOGGER.log(System.Logger.Level.TRACE, "  - " + injection.debugSelector);
                }
            }
        }
        return injections;
    }

    @Override
    public <T extends Rule> T registerRule(IntFunction<T> factory) {
        int id = ++this.lastRuleId;
        @Nullable Rule result = (Rule)factory.apply(id);
        this.ruleId2desc.put(id, result);
        return (T)result;
    }

    @Override
    public Rule getRule(int patternId) {
        Rule rule = this.ruleId2desc.get(patternId);
        if (rule == null) {
            throw new IndexOutOfBoundsException("No rule with index " + patternId + " found. Possible values: 0.." + this.ruleId2desc.size());
        }
        return rule;
    }

    @Override
    public @Nullable IRawGrammar getExternalGrammar(String scopeName, @Nullable IRawRepository repository) {
        if (this.includedGrammars.containsKey(scopeName)) {
            return this.includedGrammars.get(scopeName);
        }
        IRawGrammar rawIncludedGrammar = this.grammarRepository.lookup(scopeName);
        if (rawIncludedGrammar != null) {
            this.includedGrammars.put(scopeName, this.initGrammar(rawIncludedGrammar, repository != null ? repository.getBase() : null));
            return this.includedGrammars.get(scopeName);
        }
        return null;
    }

    private IRawGrammar initGrammar(IRawGrammar grammar, @Nullable IRawRule base) {
        IRawRepository repo;
        if ((grammar = grammar.deepClone()).isRepositorySet()) {
            repo = grammar.getRepository();
        } else {
            repo = new RawRepository();
            grammar.setRepository(repo);
        }
        RawRule self = new RawRule();
        self.setPatterns(grammar.getPatterns());
        self.setName(grammar.getScopeName());
        repo.setSelf(self);
        repo.setBase(base != null ? base : self);
        return grammar;
    }

    @Override
    public ITokenizeLineResult tokenizeLine(String lineText) {
        return this.tokenizeLine(lineText, null);
    }

    @Override
    public ITokenizeLineResult tokenizeLine(String lineText, @Nullable IStackElement prevState) {
        return (ITokenizeLineResult)this.tokenize(lineText, (StackElement)prevState, false);
    }

    @Override
    public ITokenizeLineResult2 tokenizeLine2(String lineText) {
        return this.tokenizeLine2(lineText, null);
    }

    @Override
    public ITokenizeLineResult2 tokenizeLine2(String lineText, @Nullable IStackElement prevState) {
        return (ITokenizeLineResult2)this.tokenize(lineText, (StackElement)prevState, true);
    }

    private <T> T tokenize(String lineText, @Nullable StackElement prevState, boolean emitBinaryTokens) {
        boolean isFirstLine;
        if (this.rootId == -1) {
            this.rootId = RuleFactory.getCompiledRuleId(this.grammar.getRepository().getSelf(), this, this.grammar.getRepository());
        }
        if (prevState == null || prevState.equals(StackElement.NULL)) {
            isFirstLine = true;
            ScopeMetadata rawDefaultMetadata = this.scopeMetadataProvider.getDefaultMetadata();
            List<ThemeTrieElementRule> themeData = rawDefaultMetadata.themeData;
            ThemeTrieElementRule defaultTheme = themeData == null ? null : themeData.get(0);
            int defaultMetadata = StackElementMetadata.set(0, rawDefaultMetadata.languageId, rawDefaultMetadata.tokenType, null, defaultTheme.fontStyle, defaultTheme.foreground, defaultTheme.background);
            Rule rootRule = NullSafetyHelper.castNonNull(this.getRule(this.rootId));
            String rootScopeName = rootRule.getName(null, null);
            ScopeMetadata rawRootMetadata = this.scopeMetadataProvider.getMetadataForScope(rootScopeName);
            int rootMetadata = ScopeListElement.mergeMetadata(defaultMetadata, null, rawRootMetadata);
            ScopeListElement scopeList = new ScopeListElement(null, rootScopeName == null ? "unknown" : rootScopeName, rootMetadata);
            prevState = new StackElement(null, this.rootId, -1, -1, false, null, scopeList, scopeList);
        } else {
            isFirstLine = false;
            prevState.reset();
        }
        if (lineText.isEmpty() || lineText.charAt(lineText.length() - 1) != '\n') {
            lineText = String.valueOf(lineText) + '\n';
        }
        OnigString onigLineText = OnigString.of(lineText);
        int lineLength = lineText.length();
        LineTokens lineTokens = new LineTokens(emitBinaryTokens, lineText, this.tokenTypeMatchers, this.balancedBracketSelectors);
        StackElement nextState = LineTokenizer.tokenizeString(this, onigLineText, isFirstLine, 0, prevState, lineTokens, true);
        if (emitBinaryTokens) {
            return (T)new TokenizeLineResult2(lineTokens.getBinaryResult(nextState, lineLength), nextState);
        }
        return (T)new TokenizeLineResult(lineTokens.getResult(nextState, lineLength), nextState);
    }

    @Override
    public @Nullable String getName() {
        return this.grammar.getName();
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public Collection<String> getFileTypes() {
        return this.grammar.getFileTypes();
    }

    private /* synthetic */ void lambda$0(2 var1_1, ArrayList arrayList, String scopeName) {
        Collection<String> injectionScopeNames;
        IRawGrammar grammar = var1_1.lookup(scopeName);
        if (grammar == null) {
            return;
        }
        Map<String, IRawRule> rawInjections = grammar.getInjections();
        if (rawInjections != null) {
            for (Map.Entry<String, IRawRule> e : rawInjections.entrySet()) {
                this.collectInjections(arrayList, e.getKey(), e.getValue(), this, grammar);
            }
        }
        if ((injectionScopeNames = this.grammarRepository.injections(scopeName)) != null) {
            injectionScopeNames.forEach(injectionScopeName -> {
                String selector;
                IRawGrammar injectionGrammar = this.getExternalGrammar((String)injectionScopeName, null);
                if (injectionGrammar != null && (selector = injectionGrammar.getInjectionSelector()) != null) {
                    this.collectInjections(arrayList, selector, injectionGrammar.toRawRule(), this, injectionGrammar);
                }
            });
        }
    }
}

