/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarEntry
implements Cloneable {
    public byte[] name = new byte[100];
    public byte[] mode = new byte[8];
    public byte[] uid = new byte[8];
    public byte[] gid = new byte[8];
    public byte[] size = new byte[12];
    public byte[] mtime = new byte[12];
    public byte[] chksum = new byte[8];
    public byte typeflag;
    public byte[] linkname = new byte[100];
    public byte[] magic = new byte[6];
    public byte[] version = new byte[2];
    public byte[] uname = new byte[32];
    public byte[] gname = new byte[32];
    public byte[] devmajor = new byte[8];
    public byte[] devminor = new byte[8];
    public byte[] prefix = new byte[155];

    public TarEntry(String name) {
        this.setName(name);
    }

    TarEntry(byte[] blockData) throws IOException {
        this.checkNull(blockData);
        if (blockData.length != 512) {
            throw new IllegalArgumentException();
        }
        this.populateFields(blockData);
    }

    private void populateFields(byte[] blockData) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(blockData);
        byteStream.read(this.name);
        if (this.getName().equals("")) {
            return;
        }
        byteStream.read(this.mode);
        byteStream.read(this.uid);
        byteStream.read(this.gid);
        byteStream.read(this.size);
        byteStream.read(this.mtime);
        byteStream.read(this.chksum);
        this.typeflag = (byte)((InputStream)byteStream).read();
        byteStream.read(this.linkname);
        byteStream.read(this.magic);
        byteStream.read(this.version);
        byteStream.read(this.uname);
        byteStream.read(this.gname);
        byteStream.read(this.devmajor);
        byteStream.read(this.devminor);
        byteStream.read(this.prefix);
    }

    private void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    public void setName(String fileName) {
        this.checkNull(fileName);
        int length = 100 - fileName.length();
        int i = 0;
        while (i < length) {
            fileName = String.valueOf(fileName) + "\u0000";
            ++i;
        }
        this.name = fileName.getBytes();
    }

    public String getName() {
        return new String(this.name).trim();
    }

    public void setUserMode(boolean canRead, boolean canWrite, boolean canExecute) {
        int mod = 0;
        if (canRead) {
            mod += 4;
        }
        if (canWrite) {
            mod += 2;
        }
        if (canExecute) {
            ++mod;
        }
        String modString = "0100" + Integer.toString(mod, 8) + "44";
        modString = String.valueOf(modString) + "\u0000";
        this.mode = modString.getBytes();
    }

    public String getMode() {
        return new String(this.mode).trim();
    }

    public String getUID() {
        return new String(this.uid).trim();
    }

    public String getGID() {
        return new String(this.gid).trim();
    }

    public void setSize(long fileSize) {
        String sizeString = Long.toString(fileSize, 8).trim();
        int length = sizeString.length();
        int diff = 12 - length - 1;
        int i = 0;
        while (i < diff) {
            sizeString = "0" + sizeString;
            ++i;
        }
        sizeString = String.valueOf(sizeString) + " ";
        this.size = sizeString.getBytes();
    }

    public long getSize() {
        return Long.parseLong(new String(this.size).trim(), 8);
    }

    public void setModificationTime(long modTime) {
        String mtimeString = Long.toString(modTime / 1000L, 8).trim();
        int length = mtimeString.length();
        int diff = 12 - length - 1;
        int i = 0;
        while (i < diff) {
            mtimeString = "0" + mtimeString;
            ++i;
        }
        mtimeString = String.valueOf(mtimeString) + " ";
        this.mtime = mtimeString.getBytes();
    }

    public long getModificationTime() {
        return Long.parseLong(new String(this.mtime).trim(), 8) * 1000L;
    }

    public long getChecksum() {
        return Long.parseLong(new String(this.chksum).trim(), 8);
    }

    public char getTypeFlag() {
        return (char)this.typeflag;
    }

    public String getLinkName() {
        return new String(this.linkname).trim();
    }

    public String getMagic() {
        return new String(this.magic).trim();
    }

    public String getVersion() {
        return new String(this.version).trim();
    }

    public void setUserName(String userName) {
        this.checkNull(userName);
        int length = 32 - userName.length();
        int i = 0;
        while (i < length) {
            userName = String.valueOf(userName) + "\u0000";
            ++i;
        }
        this.uname = userName.getBytes();
    }

    public String getUserName() {
        return new String(this.uname).trim();
    }

    public String getGroupName() {
        return new String(this.gname).trim();
    }

    public String getDevMajor() {
        return new String(this.devmajor).trim();
    }

    public String getDevMinor() {
        return new String(this.devminor).trim();
    }

    public String getPrefix() {
        return new String(this.prefix).trim();
    }

    public boolean isDirectory() {
        String entryName = this.getName();
        return entryName.endsWith("/");
    }

    public void writeFields(OutputStream outStream) throws IOException {
        outStream.write(this.name);
        outStream.write(this.mode);
        outStream.write(this.uid);
        outStream.write(this.gid);
        outStream.write(this.size);
        outStream.write(this.mtime);
        outStream.write(this.chksum);
        outStream.write(this.typeflag);
        outStream.write(this.linkname);
        outStream.write(this.magic);
        outStream.write(this.version);
        outStream.write(this.uname);
        outStream.write(this.gname);
        outStream.write(this.devmajor);
        outStream.write(this.devminor);
        outStream.write(this.prefix);
    }

    public void calculateChecksum() {
        int sum = 0;
        int i = 0;
        while (i < this.name.length) {
            sum += this.name[i];
            ++i;
        }
        i = 0;
        while (i < this.mode.length) {
            sum += this.mode[i];
            ++i;
        }
        i = 0;
        while (i < this.uid.length) {
            sum += this.uid[i];
            ++i;
        }
        i = 0;
        while (i < this.gid.length) {
            sum += this.gid[i];
            ++i;
        }
        i = 0;
        while (i < this.size.length) {
            sum += this.size[i];
            ++i;
        }
        i = 0;
        while (i < this.mtime.length) {
            sum += this.mtime[i];
            ++i;
        }
        int space = 32;
        byte spaceByte = (byte)space;
        int i2 = 0;
        while (i2 < this.chksum.length) {
            sum += spaceByte;
            ++i2;
        }
        sum += this.typeflag;
        i2 = 0;
        while (i2 < this.linkname.length) {
            sum += this.linkname[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.magic.length) {
            sum += this.magic[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.version.length) {
            sum += this.version[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.uname.length) {
            sum += this.uname[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.gname.length) {
            sum += this.gname[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.devmajor.length) {
            sum += this.devmajor[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.devminor.length) {
            sum += this.devminor[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.prefix.length) {
            sum += this.prefix[i2];
            ++i2;
        }
        String sumString = Long.toString(sum, 8).trim();
        int length = sumString.length();
        int diff = 8 - length - 2;
        int i3 = 0;
        while (i3 < diff) {
            sumString = "0" + sumString;
            ++i3;
        }
        sumString = String.valueOf(sumString) + "\u0000";
        sumString = String.valueOf(sumString) + " ";
        this.chksum = sumString.getBytes();
    }

    public Object clone() throws CloneNotSupportedException {
        TarEntry newEntry = (TarEntry)super.clone();
        newEntry.mode = (byte[])this.mode.clone();
        newEntry.uid = (byte[])this.uid.clone();
        newEntry.gid = (byte[])this.gid.clone();
        newEntry.size = (byte[])this.size.clone();
        newEntry.mtime = (byte[])this.mtime.clone();
        newEntry.chksum = (byte[])this.chksum.clone();
        newEntry.linkname = (byte[])this.linkname.clone();
        newEntry.magic = (byte[])this.magic.clone();
        newEntry.version = (byte[])this.version.clone();
        newEntry.uname = (byte[])this.uname.clone();
        newEntry.gname = (byte[])this.gname.clone();
        newEntry.devmajor = (byte[])this.devmajor.clone();
        newEntry.devminor = (byte[])this.devminor.clone();
        newEntry.prefix = (byte[])this.prefix.clone();
        return newEntry;
    }
}

