/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.highlighter.internal;

import org.eclipse.rcptt.core.ecl.highlighter.EclHighlighter;
import org.eclipse.rcptt.core.ecl.scanner.EclScanner;
import org.eclipse.rcptt.core.ecl.scanner.EclToken;

public class ScanningHighlighter {
    /*
     * Enabled aggressive block sorting
     */
    public void highlight(EclScanner scanner, EclHighlighter.Strategy strategy) {
        int p = 0;
        boolean commandStart = true;
        while (true) {
            EclHighlighter.RunType type = EclHighlighter.RunType.Invalid;
            EclToken t = scanner.next();
            switch (t.type) {
                case Eof: {
                    return;
                }
                case Linebreak: {
                    commandStart = true;
                }
                case Spacing: {
                    type = EclHighlighter.RunType.Spacing;
                    break;
                }
                case SlComment: 
                case MlComment: {
                    type = EclHighlighter.RunType.Comment;
                    break;
                }
                case Pipe: 
                case Semicolon: 
                case SquareOpen: 
                case CurlyOpen: {
                    commandStart = true;
                }
                case Plus: 
                case SquareClose: 
                case CurlyClose: {
                    type = EclHighlighter.RunType.Punctuation;
                    break;
                }
                case Option: {
                    type = EclHighlighter.RunType.Option;
                    break;
                }
                case Identifier: {
                    if (commandStart) {
                        type = EclHighlighter.RunType.Command;
                        commandStart = false;
                        break;
                    }
                }
                case Number: 
                case String: {
                    type = EclHighlighter.RunType.Literal;
                    break;
                }
                case Variable: {
                    type = EclHighlighter.RunType.Variable;
                    commandStart = false;
                }
            }
            strategy.highlight(type, p, p + t.text.length());
            p += t.text.length();
        }
    }
}

