/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class WorkspaceSymbolService {
    @Inject
    private IResourceServiceProvider.Registry registry;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public List<? extends SymbolInformation> getSymbols(String query, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        LinkedList<? extends SymbolInformation> result = new LinkedList<SymbolInformation>();
        for (IResourceDescription resourceDescription : indexData.getAllResourceDescriptions()) {
            DocumentSymbolService documentSymbolService;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(resourceDescription.getURI());
            if (resourceServiceProvider == null || (documentSymbolService = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class)) == null) continue;
            result.addAll(documentSymbolService.getSymbols(resourceDescription, query, resourceAccess, cancelIndicator));
        }
        return result;
    }
}

