/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public interface IRenameStrategy2 {
    public void applyRename(RenameContext var1);

    public static class DefaultImpl
    implements IRenameStrategy2 {
        @Inject
        private IResourceServiceProvider resourceServiceProvider;

        public boolean canHandle(RenameChange change) {
            return this.resourceServiceProvider.canHandle(change.getTargetURI());
        }

        @Override
        public void applyRename(RenameContext context) {
            for (RenameChange renameChange : context.getChanges()) {
                if (!this.canHandle(renameChange)) continue;
                context.addModification(renameChange, o -> this.doRename((EObject)o, change, context));
            }
        }

        protected void doRename(EObject target, RenameChange change, RenameContext context) {
            EAttribute nameAttribute = this.getNameEAttribute(target);
            if (nameAttribute != null) {
                target.eSet((EStructuralFeature)nameAttribute, (Object)change.getNewName());
            } else {
                context.getIssues().add(RefactoringIssueAcceptor.Severity.WARNING, "Element of class " + target.eClass().getName() + " cannot be renamed.", new Object[0]);
            }
        }

        protected EAttribute getNameEAttribute(EObject target) {
            for (EAttribute attribute : target.eClass().getEAllAttributes()) {
                if (!"name".equals(attribute.getName()) || EcorePackage.Literals.ESTRING != attribute.getEType()) continue;
                return attribute;
            }
            return null;
        }
    }
}

