/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.report.impl;

import java.io.StringReader;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultType;
import org.eclipse.wst.wsi.internal.core.report.ArtifactReference;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.EntryContainer;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;
import org.eclipse.wst.wsi.internal.core.report.Report;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.ReportWriter;
import org.eclipse.wst.wsi.internal.core.report.Reporter;

public class DefaultReporter
implements Reporter {
    protected Report report;
    protected ReportWriter reportWriter;
    protected AnalyzerConfig analyzerConfig;
    protected AssertionResultType assertionResultType;

    public DefaultReporter(Report report, ReportWriter reportWriter) {
        this.report = report;
        this.reportWriter = reportWriter;
        this.analyzerConfig = report.getReportContext().getAnalyzer().getAnalyzerConfig();
        this.assertionResultType = this.analyzerConfig.getAssertionResultsOption().getAssertionResultType();
    }

    @Override
    public void setCurrentArtifact(ReportArtifact reportArtifact) throws WSIException {
        this.report.setCurrentArtifact(reportArtifact);
        this.reportWriter.write(new StringReader(reportArtifact.getStartXMLString("")));
    }

    @Override
    public void endCurrentArtifact() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getCurrentArtifact().getEndXMLString("")));
        this.report.endCurrentArtifact();
    }

    @Override
    public void addArtifactReference(ArtifactReference artifactReference) throws WSIException {
        this.reportWriter.write(new StringReader(artifactReference.toXMLString("")));
        this.report.addArtifactReference(artifactReference);
    }

    @Override
    public void setCurrentEntry(Entry entry) throws WSIException {
        this.report.setCurrentEntry(entry);
        this.reportWriter.write(new StringReader(entry.getStartXMLString("", this.report.getReportContext().getAnalyzer().getAnalyzerConfig().getAssertionResultsOption().getShowMessageEntry())));
    }

    @Override
    public void setCurrentEnvelopeEntry(Entry entry) throws WSIException {
        this.report.setCurrentEntry(entry);
        this.reportWriter.write(new StringReader(entry.getStartXMLString("", this.report.getReportContext().getAnalyzer().getAnalyzerConfig().getAssertionResultsOption().getShowMessageEntry(), true)));
    }

    @Override
    public void endCurrentEntry() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getCurrentEntry().getEndXMLString("")));
        this.report.endCurrentEntry();
    }

    @Override
    public void addAssertionResult(AssertionResult assertionResult) throws WSIException {
        if (this.assertionResultType.isAll() || this.assertionResultType.isFailedOnly() && assertionResult.getResult().equals("failed") || this.assertionResultType.isNotPassed() && !assertionResult.getResult().equals("passed") || this.assertionResultType.isNotInfo() && !assertionResult.getAssertion().getType().equals("informational")) {
            this.reportWriter.write(new StringReader(assertionResult.toXMLString("")));
        }
        this.report.addAssertionResult(assertionResult);
    }

    @Override
    public AssertionResult getAssertionResult(String assertionId) {
        return this.report.getAssertionResult(assertionId);
    }

    @Override
    public void startReport() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getStartXMLString("")));
    }

    @Override
    public void finishReport() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getEndXMLString("")));
    }

    @Override
    public void finishReportWithError(String errorDetail) throws WSIException {
        if (this.report.getCurrentEntry() != null) {
            this.endCurrentEntry();
        }
        if (this.report.getCurrentArtifact() != null) {
            this.endCurrentArtifact();
        }
        this.reportWriter.write(new StringReader(this.report.getErrorXMLString("", errorDetail)));
    }

    @Override
    public AssertionResult createAssertionResult() {
        return this.report.createAssertionResult();
    }

    @Override
    public ReportArtifact createArtifact() {
        return this.report.createArtifact();
    }

    @Override
    public Entry createEntry() {
        return this.report.createEntry();
    }

    @Override
    public EntryContainer createEntryContainer() {
        return this.report.createEntryContainer();
    }

    @Override
    public FailureDetail createFailureDetail() {
        return this.report.createFailureDetail();
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public void setPrereqType(String prereqType) {
        this.report.setPrereqType(prereqType);
    }
}

