/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.steps;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.te.core.utils.text.StringUtil;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;

public class LaunchProcessStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        String processImage = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (processImage == null || processImage.trim().length() <= 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing process image name"));
        }
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)processImage);
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
        String processArguments = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)processArguments);
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        boolean attachProcess;
        String outputFile;
        final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        Assert.isTrue((channel != null && channel.getState() == 1 ? 1 : 0) != 0, (String)"channel is missing or closed");
        final ProcessLauncher launcher = new ProcessLauncher();
        HashMap<String, Object> launchAttributes = new HashMap<String, Object>();
        launchAttributes.put("process.path", StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data));
        String arguments = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        String[] args = arguments != null && !"".equals(arguments.trim()) ? StringUtil.tokenize((String)arguments, (int)0, (boolean)true) : null;
        launchAttributes.put("process.args", args);
        launchAttributes.put("localEcho", Boolean.FALSE);
        boolean outputConsole = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_output_console", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (outputConsole) {
            launchAttributes.put("process.associateConsole", Boolean.TRUE);
        }
        if ((outputFile = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_output_file", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) != null) {
            launchAttributes.put("process.redirectToFile", outputFile);
        }
        if (attachProcess = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_attach", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) {
            boolean attachChildren;
            boolean stopAtMain;
            launchAttributes.put("process.attach", Boolean.TRUE);
            boolean stopAtEntry = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_entry", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
            if (stopAtEntry) {
                launchAttributes.put("StopAtEntry", Boolean.TRUE);
            }
            if (stopAtMain = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_main", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) {
                launchAttributes.put("StopAtMain", Boolean.TRUE);
            }
            if (attachChildren = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_attach_children", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) {
                launchAttributes.put("AttachChildren", Boolean.TRUE);
            }
        }
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        PropertiesContainer container = new PropertiesContainer();
        container.setProperties(launchAttributes);
        if (container.getProperty("lineSeparator") == null) {
            final AtomicBoolean isLocalhost = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if ("TCP".equals(peer.getTransportName()) || "SSL".equals(peer.getTransportName())) {
                        isLocalhost.set(IPAddressUtil.getInstance().isLocalHost((String)peer.getAttributes().get("Host")));
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            if (isLocalhost.get()) {
                container.setProperty("lineSeparator", (Object)(Host.isWindowsHost() ? "\\r\\n" : "\\n"));
            }
        }
        launcher.launch(peer, (IPropertiesContainer)container, (ICallback)new Callback(callback){

            protected void internalDone(Object caller, IStatus status) {
                Object result = this.getResult();
                if (status.isOK()) {
                    if (result instanceof IProcesses.ProcessContext) {
                        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context", (IFullQualifiedId)fullQualifiedId.getParentId(), (IPropertiesContainer)data, (Object)result);
                    }
                    StepperAttributeUtil.setProperty((String)"services.processes.name", (IFullQualifiedId)fullQualifiedId.getParentId(), (IPropertiesContainer)data, (Object)(launcher.getSvcProcesses() instanceof IProcessesV1 ? "ProcessesV1" : "Processes"));
                }
                Assert.isTrue((channel.getState() == 1 ? 1 : 0) != 0, (String)"channel is closed");
                super.internalDone(caller, status);
            }
        });
    }
}

