/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;

public class SystemProfile
extends RSEModelObject
implements ISystemProfile,
IAdaptable {
    private ISystemProfileManager mgr = null;
    private IRSEPersistenceProvider provider = null;
    private boolean isActive = true;
    private String name = null;
    private boolean defaultPrivate = false;
    private boolean suspended = false;

    protected SystemProfile() {
    }

    public SystemProfile(String name, boolean isActive) {
        this.name = name;
        this.isActive = isActive;
    }

    public void setProfileManager(ISystemProfileManager mgr) {
        this.mgr = mgr;
    }

    public ISystemProfileManager getProfileManager() {
        return this.mgr;
    }

    public IHost[] getHosts() {
        return RSECorePlugin.getTheSystemRegistry().getHostsByProfile(this);
    }

    public ISystemFilterPool[] getFilterPools() {
        ArrayList<ISystemFilterPool> filterPools = new ArrayList<ISystemFilterPool>(10);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfigurationProxy[] proxies = registry.getSubSystemConfigurationProxies();
        int i = 0;
        while (i < proxies.length) {
            ISubSystemConfigurationProxy proxy = proxies[i];
            if (proxy.isSubSystemConfigurationActive()) {
                ISubSystemConfiguration config = proxy.getSubSystemConfiguration();
                ISystemFilterPoolManager fpm = config.getFilterPoolManager(this);
                ISystemFilterPool[] poolArray = fpm.getSystemFilterPools();
                filterPools.addAll(Arrays.asList(poolArray));
            }
            ++i;
        }
        ISystemFilterPool[] result = new ISystemFilterPool[filterPools.size()];
        filterPools.toArray(result);
        return result;
    }

    public ISystemFilterPool[] getFilterPools(ISubSystemConfiguration ssf) {
        ISystemFilterPoolManager poolMgr = ssf.getFilterPoolManager(this);
        return poolMgr.getSystemFilterPools();
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean activate) {
        if (activate) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    private void activate() {
        if (!this.isActive) {
            this.isActive = true;
            this.setDirty(true);
            RSEPreferencesManager.addActiveProfile(this.getName());
        }
    }

    private void deactivate() {
        ISystemProfile defaultProfile = this.mgr.getDefaultPrivateSystemProfile();
        if (this.isActive && this != defaultProfile) {
            this.isActive = false;
            this.setDirty(true);
            RSEPreferencesManager.deleteActiveProfile(this.getName());
        }
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String toString() {
        String result = this.getName();
        if (result == null) {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append("Profile(name: ");
            buf.append(this.name);
            buf.append(", defaultPrivate: ");
            buf.append(this.defaultPrivate);
            buf.append(')');
            result = buf.toString();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_PROFILE_DESCRIPTION;
    }

    public void setName(String newName) {
        if (newName.indexOf("___") >= 0) {
            throw new IllegalArgumentException("Cannot have ___ in profile name.");
        }
        String oldName = this.name;
        if (!newName.equals(oldName)) {
            this.name = newName;
            this.setDirty(true);
            if (this.isActive) {
                RSEPreferencesManager.renameActiveProfile(oldName, newName);
            }
        }
    }

    public boolean isDefaultPrivate() {
        return this.defaultPrivate;
    }

    public void setDefaultPrivate(boolean newDefaultPrivate) {
        this.defaultPrivate = newDefaultPrivate;
        this.setDirty(true);
    }

    public boolean commit() {
        boolean scheduled = false;
        if (!this.suspended) {
            IStatus status = SystemProfileManager.getDefault().commitSystemProfile(this);
            scheduled = status.isOK();
        }
        return scheduled;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<IPropertySetContainer> children = new ArrayList<IPropertySetContainer>(10);
        children.addAll(Arrays.asList(this.getFilterPools()));
        children.addAll(Arrays.asList(this.getHosts()));
        children.addAll(Arrays.asList(this.getPropertySets()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }

    public IRSEPersistenceProvider getPersistenceProvider() {
        return this.provider;
    }

    public void setPersistenceProvider(IRSEPersistenceProvider provider) {
        this.provider = provider;
    }
}

