/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.context;

import com.ibm.icu.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.context.Messages;
import org.eclipse.mylyn.internal.tasks.ui.context.TaskAttachmentComparator;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ContextRetrieveWizardPage
extends WizardPage {
    private final TaskRepository repository;
    private final ITask task;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private ITaskAttachment selectedContextAttachment;

    protected ContextRetrieveWizardPage(TaskRepository repository, ITask task) {
        super(Messages.ContextRetrieveWizardPage_Select_context);
        this.repository = repository;
        this.task = task;
        this.setDescription(Messages.ContextRetrieveWizardPage_SELECT_A_CONTEXT_TO_RETTRIEVE_FROM_TABLE_BELOW);
        this.setTitle(Messages.ContextRetrieveWizardPage_Select_context);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Text summary = new Text(composite, 0);
        summary.setText(NLS.bind((String)Messages.ContextRetrieveWizardPage_Task, (Object)this.labelProvider.getText(this.task)));
        summary.setEditable(false);
        final Table contextTable = new Table(composite, 67584);
        contextTable.setHeaderVisible(true);
        contextTable.setLinesVisible(true);
        contextTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (contextTable.getSelectionIndex() > -1) {
                    ContextRetrieveWizardPage.this.selectedContextAttachment = (ITaskAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                    ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        contextTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ContextRetrieveWizardPage.this.selectedContextAttachment = (ITaskAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                ContextRetrieveWizardPage.this.getWizard().performFinish();
                ContextRetrieveWizardPage.this.getWizard().getContainer().getShell().close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        List<ITaskAttachment> contextAttachments = AttachmentUtil.getContextAttachments(this.repository, this.task);
        Collections.sort(contextAttachments, new TaskAttachmentComparator());
        TableColumn[] columns = new TableColumn[3];
        columns[0] = new TableColumn(contextTable, 16384);
        columns[0].setText(Messages.ContextRetrieveWizardPage_Date);
        columns[1] = new TableColumn(contextTable, 16384);
        columns[1].setText(Messages.ContextRetrieveWizardPage_Author);
        columns[2] = new TableColumn(contextTable, 0x1000000);
        columns[2].setText(Messages.ContextRetrieveWizardPage_Description);
        for (ITaskAttachment attachment : contextAttachments) {
            IRepositoryPerson author;
            TableItem item = new TableItem(contextTable, 0);
            Date creationDate = attachment.getCreationDate();
            if (creationDate != null) {
                item.setText(0, DateFormat.getInstance().format(creationDate));
            }
            if ((author = attachment.getAuthor()) != null) {
                item.setText(1, author.toString());
            }
            item.setText(2, attachment.getDescription());
            item.setData((Object)attachment);
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        contextTable.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        if (contextAttachments.size() > 0) {
            contextTable.setSelection(0);
            this.selectedContextAttachment = contextAttachments.get(0);
            this.getWizard().getContainer().updateButtons();
        }
        contextTable.setFocus();
        Dialog.applyDialogFont((Control)composite);
    }

    public ITaskAttachment getSelectedContext() {
        return this.selectedContextAttachment;
    }

    public boolean isPageComplete() {
        if (this.selectedContextAttachment == null) {
            return false;
        }
        return super.isPageComplete();
    }
}

