/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Collection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.PresentationFilter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public abstract class AbstractTaskListFilter {
    public abstract boolean select(Object var1, Object var2);

    public boolean applyToFilteredText() {
        return false;
    }

    public static boolean hasDescendantIncoming(ITaskContainer container) {
        return AbstractTaskListFilter.hasDescendantIncoming(container, 10);
    }

    public static boolean hasIncompleteDescendant(ITaskContainer container) {
        return AbstractTaskListFilter.hasIncompleteDescendant(container, 10);
    }

    private static boolean hasDescendantIncoming(ITaskContainer container, int depth) {
        Collection children = container.getChildren();
        if (children == null || depth <= 0) {
            return false;
        }
        if (!PresentationFilter.getInstance().select(null, container)) {
            return false;
        }
        for (ITask task : children) {
            if (task == null || !PresentationFilter.getInstance().select(container, task)) continue;
            if (TasksUiInternal.shouldShowIncoming(task)) {
                return true;
            }
            if (!TasksUiPlugin.getDefault().groupSubtasks(container) || !(task instanceof ITaskContainer) || !AbstractTaskListFilter.hasDescendantIncoming((ITaskContainer)task, depth - 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIncompleteDescendant(ITaskContainer container, int depth) {
        Collection children = container.getChildren();
        if (children == null || depth <= 0) {
            return false;
        }
        for (ITask task : children) {
            if (task == null) continue;
            ITask containedRepositoryTask = task;
            if (!containedRepositoryTask.isCompleted()) {
                return true;
            }
            if (!(task instanceof ITaskContainer) || !AbstractTaskListFilter.hasIncompleteDescendant((ITaskContainer)task, depth - 1)) continue;
            return true;
        }
        return false;
    }
}

