/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.acquire.IBMExecVmInfo;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="IBM Dump (using helper VM)")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__3")
public class IBMExecDumpProvider
extends BaseProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.ibmdump";
    private static final String JAVA_EXEC = "java";
    private static final String JAVA_EXEC_WINDOWS = "java.exe";
    private static final String JCMD = "jcmd";
    private static final String[] ibmmodules = new String[]{"jdmpview", "jdmpview.exe", "jextract", "jextract.exe"};
    private static final String[] hprofmodules = new String[]{"jinfo", "jinfo.exe", "jstatd", "jstatd.exe"};
    private static boolean abort = false;
    private int lastCount = 20;
    @Argument(isMandatory=false)
    public File javaexecutable;
    @Argument(isMandatory=false)
    public List<File> javaList;
    @Argument(isMandatory=false)
    public String[] vmoptions = new String[0];
    private DumpType defaultTypeCopy;
    public File javaexecutableCopy;
    private static final String last_directory_key = String.valueOf(IBMExecDumpProvider.class.getName()) + ".lastDir";
    private static String savedJavaDir;
    private static File execJar;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType;

    public IBMExecDumpProvider() {
        try {
            Class.forName("com.ibm.jvm.Dump");
        }
        catch (ClassNotFoundException e) {
            this.defaultType = DumpType.HPROF;
        }
        this.fillJavaList();
        this.defaultTypeCopy = this.defaultType;
    }

    /*
     * Exception decompiling
     */
    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [37[UNCONDITIONALDOLOOP], 24[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File javaExec(String dir) {
        if (dir != null) {
            return IBMExecDumpProvider.jvmExec(new File(dir), JAVA_EXEC);
        }
        return IBMExecDumpProvider.jvmExec(null, JAVA_EXEC);
    }

    private File javaExec(File dir) {
        return IBMExecDumpProvider.jvmExec(dir, JAVA_EXEC);
    }

    static File jvmExec(File javaDir, String exec) {
        File javaExec = javaDir != null ? new File(javaDir, exec) : new File(exec);
        return javaExec;
    }

    public List<VmInfo> getAvailableVMs(IProgressListener listener) {
        List<VmInfo> ret;
        String javaDir;
        if (abort) {
            return Collections.emptyList();
        }
        File javaExec = this.javaexecutable;
        if (this.javaList == null || this.javaList.isEmpty() || this.defaultTypeCopy == DumpType.HPROF != (this.defaultType == DumpType.HPROF)) {
            this.fillJavaList();
        }
        this.defaultTypeCopy = this.defaultType;
        if (javaExec != null) {
            javaDir = javaExec.getParent();
        } else {
            File javaExec2;
            javaDir = IBMExecDumpProvider.lastJavaDir();
            if (javaDir == null) {
                if (this.javaList == null || this.javaList.isEmpty()) {
                    this.fillJavaList();
                }
                if (this.javaList.size() >= 1) {
                    javaDir = this.javaList.get(0).getParent();
                }
            }
            if (!(javaExec = this.javaExec(javaDir)).canExecute() && (javaExec2 = IBMExecDumpProvider.jvmExec(new File(javaDir), JAVA_EXEC_WINDOWS)).canExecute()) {
                javaExec = javaExec2;
            }
        }
        if (javaExec != null && javaExec.canExecute() && !javaExec.equals(this.javaexecutableCopy)) {
            String mod;
            if (this.defaultType == DumpType.HPROF) {
                String[] stringArray = ibmmodules;
                int n = ibmmodules.length;
                int n2 = 0;
                while (n2 < n) {
                    mod = stringArray[n2];
                    File modf = new File(javaExec.getParentFile(), mod);
                    if (modf.canExecute()) {
                        this.defaultType = DumpType.SYSTEM;
                        break;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = hprofmodules;
                int n = hprofmodules.length;
                int n3 = 0;
                while (n3 < n) {
                    mod = stringArray[n3];
                    File modf = new File(javaExec.getParentFile(), mod);
                    if (modf.canExecute()) {
                        this.defaultType = DumpType.HPROF;
                        break;
                    }
                    ++n3;
                }
            }
        }
        if ((ret = this.execGetVMs(javaExec, listener)) != null) {
            IBMExecDumpProvider.setJavaDir(javaDir);
            this.javaexecutable = javaExec;
            this.javaexecutableCopy = javaExec;
        }
        return ret;
    }

    private void fillJavaList() {
        List<File> dirs = this.defaultJavaDirs();
        this.javaList = new ArrayList<File>();
        for (File d : dirs) {
            File javaExec = this.javaExec(d);
            if (javaExec.canExecute()) {
                this.javaList.add(javaExec);
                continue;
            }
            javaExec = IBMExecDumpProvider.jvmExec(d, JAVA_EXEC_WINDOWS);
            if (!javaExec.canExecute()) continue;
            this.javaList.add(javaExec);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<File> defaultJavaDirs() {
        String path;
        Object f2;
        String s1;
        ArrayList<File> ret = new ArrayList<File>();
        String[] modules = this.defaultType == DumpType.HPROF ? hprofmodules : ibmmodules;
        ArrayList<Object> paths = new ArrayList<Object>();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
        if (prefs != null && (s1 = prefs.get("org.eclipse.jdt.launching.PREF_VM_XML", null)) != null) {
            try {
                List<File> list = IBMExecDumpProvider.parseJDTvmSettings(s1);
                for (File file : list) {
                    f2 = new File(file, "bin");
                    paths.add(f2);
                    if (((File)f2).exists()) continue;
                    File f3 = new File(file, "jre");
                    File f4 = new File(f3, "bin");
                    paths.add(f4);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((path = System.getenv("PATH")) != null) {
            void var7_18;
            f2 = path.split(File.pathSeparator);
            int n = ((String[])f2).length;
            boolean bl = false;
            while (var7_18 < n) {
                String string = f2[var7_18];
                paths.add(new File(string));
                ++var7_18;
            }
        }
        block4: for (File file : paths) {
            File parentDir = file.getParentFile();
            File dir2 = new File(parentDir, "jre");
            dir2 = new File(file, "bin");
            String[] stringArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String mod = stringArray[n2];
                File dll = new File(file, mod);
                if (dll.canExecute() && !ret.contains(file)) {
                    ret.add(file);
                    continue block4;
                }
                dll = new File(dir2, mod);
                if (dll.canExecute() && !ret.contains(dir2)) {
                    ret.add(dir2);
                    continue block4;
                }
                ++n2;
            }
        }
        String string = System.getProperty("java.home");
        File file = new File(string, "bin");
        if (!ret.contains(file)) {
            ret.add(file);
        }
        return ret;
    }

    private static final List<File> parseJDTvmSettings(String input) throws IOException {
        try {
            JDTLaunchingSAXHandler handler = new JDTLaunchingSAXHandler();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxXmlReader = parser.getXMLReader();
            saxXmlReader.setContentHandler(handler);
            saxXmlReader.setErrorHandler(handler);
            saxXmlReader.parse(new InputSource(new StringReader(input)));
            ArrayList<File> homes = new ArrayList<File>();
            for (String home : handler.getJavaHome()) {
                File homedir = new File(home);
                File dir = new File(homedir, "bin");
                if (!dir.exists()) continue;
                File jps1 = new File(dir, "jps");
                File jps2 = new File(dir, "jps.exe");
                if (!jps1.canExecute() && !jps2.canExecute()) continue;
                homes.add(homedir);
            }
            return homes;
        }
        catch (SAXException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static synchronized String lastJavaDir() {
        String home = Platform.getPreferencesService().getString(PLUGIN_ID, last_directory_key, savedJavaDir, null);
        return home;
    }

    private static synchronized void setJavaDir(String home) {
        if (home != null && !home.equals(savedJavaDir)) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.put(last_directory_key, home);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            savedJavaDir = home;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<VmInfo> execGetVMs(File javaExec, IProgressListener listener) {
        ar = new ArrayList<VmInfo>();
        listener.beginTask(Messages.getString("IBMExecDumpProvider.ListingIBMVMs"), this.lastCount);
        count = 0;
        encoding = System.getProperty("file.encoding", "UTF-8");
        encodingOpt = "-Dfile.encoding=" + encoding;
        pb = new ProcessBuilder(new String[0]);
        p = null;
        execPath = javaExec.getPath();
        try {
            block30: {
                block29: {
                    block28: {
                        args = new ArrayList<String>(4);
                        args.add(execPath);
                        useJcmd = javaExec.getName().startsWith("jcmd");
                        if (!useJcmd) break block28;
                        args.add("-J" + encodingOpt);
                        if (this.vmoptions == null) break block29;
                        var15_14 = this.vmoptions;
                        var14_15 = this.vmoptions.length;
                        var13_17 = 0;
                        if (true) ** GOTO lbl41
                    }
                    args.add(encodingOpt);
                    if (this.vmoptions != null) {
                        args.addAll(Arrays.asList(this.vmoptions));
                    }
                    args.add("-jar");
                    jar = IBMExecDumpProvider.getExecJar().getAbsolutePath();
                    args.add(jar);
                    args.add(Boolean.toString(this.listAttach));
                    break block30;
                    do {
                        arg = var15_14[var13_17];
                        args.add("-J" + arg);
                        ++var13_17;
lbl41:
                        // 2 sources

                    } while (var13_17 < var14_15);
                }
                args.add("-l");
            }
            pb.command(args);
            p = pb.start();
            err = new StringBuffer();
            in = new StringBuffer();
            os = new InputStreamReader(p.getInputStream(), encoding);
            try {
                es = new InputStreamReader(p.getErrorStream(), encoding);
                try {
                    rc = 0;
                    while (true) {
                        if (os.ready()) {
                            in.append((char)os.read());
                            if (!useJcmd) continue;
                            listener.worked(1);
                            ++count;
                            continue;
                        }
                        while (es.ready()) {
                            read = (char)es.read();
                            err.append(read);
                            if (read != '.') continue;
                            listener.worked(1);
                            ++count;
                        }
                        try {
                            rc = p.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            Thread.sleep(500L);
                            if (listener.isCanceled()) ** break;
                            continue;
                            p.destroy();
                            this.listAttach = false;
                        }
                        break;
                    }
                    if (rc != 0) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMsRC"), (Object[])new Object[]{execPath, rc, err.toString()}), null);
                        var27_24 = ar;
                        return var27_24;
                    }
                    var21_25 = ss = in.toString().split("[\\n\\r]+");
                    var20_26 = ss.length;
                    var19_27 = 0;
                    while (var19_27 < var20_26) {
                        s = var21_25[var19_27];
                        s2 = s.split(IBMExecDumpProvider.INFO_SEPARATOR, 6);
                        if (s2.length >= 5) {
                            if (IBMExecDumpProvider.execJar == null || !s2[5].contains(IBMExecDumpProvider.execJar.getName())) {
                                enableDump = Boolean.parseBoolean(s2[1]);
                                ifo = new IBMExecVmInfo(s2[0], s2[5], enableDump, null, this);
                                ifo.javaexecutable = javaExec;
                                ifo.vmoptions = this.vmoptions;
                                t = DumpType.valueOf(s2[2]);
                                ifo.type = this.isIBMDumpType(t) != false && this.isIBMDumpType(this.defaultType) != false ? this.defaultType : t;
                                ifo.live = this.defaultLive;
                                ifo.compress = this.defaultCompress;
                                if (s2[4].length() > 0) {
                                    ifo.dumpdir = new File(s2[4]);
                                }
                                if (s2[3].length() > 0 && !s2[3].equals(ifo.getProposedFileName())) {
                                    ifo.setProposedFileName(s2[3]);
                                }
                                ar.add(ifo);
                            }
                        } else {
                            s2 = s.split(" ", 2);
                            if (s2.length == 2 && s2[0].matches("[0-9]+")) {
                                v0 = enableDump = s2[1].contains(execPath) == false;
                                if (s2[1].contains("JCmd -l")) {
                                    enableDump = false;
                                }
                                ifo = new IBMExecVmInfo(s2[0], s2[1], enableDump, null, this);
                                ifo.javaexecutable = javaExec;
                                ifo.vmoptions = this.vmoptions;
                                ifo.type = this.defaultType;
                                ifo.live = this.defaultLive;
                                ifo.compress = this.defaultCompress;
                                ar.add(ifo);
                            }
                        }
                        ++var19_27;
                    }
                }
                finally {
                    es.close();
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
        }
        catch (InterruptedException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
        }
        listener.done();
        if (count <= 0) return ar;
        this.lastCount = count;
        return ar;
    }

    private boolean isIBMDumpType(DumpType t) {
        return t == DumpType.SYSTEM || t == DumpType.HEAP || t == DumpType.JAVA;
    }

    static synchronized File getExecJar() throws IOException {
        if (execJar == null || !execJar.canRead()) {
            String jarname = "org.eclipse.mat.ibmexecdumps";
            String[] classesNames = new String[]{"org.eclipse.mat.ibmvm.acquire.IBMDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentInitializationException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentLoadException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachNotSupportedException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachOperationFailedException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachProvider", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$VirtualMachine", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$VirtualMachineDescriptor", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentLoader", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$FileComparator", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$NewFileFilter", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$StderrProgressListener", "org.eclipse.mat.ibmvm.acquire.BaseProvider", "org.eclipse.mat.ibmvm.acquire.HprofDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMHeapDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMSystemDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMJavaDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMVmInfo", "org.eclipse.mat.ibmvm.acquire.AgentLoader2", "org.eclipse.mat.ibmvm.acquire.DumpType", "org.eclipse.mat.ibmvm.agent.DumpAgent"};
            Class[] classes = new Class[]{SnapshotException.class, IHeapDumpProvider.class, VmInfo.class, IProgressListener.class, IProgressListener.OperationCanceledException.class, IProgressListener.Severity.class, Messages.class};
            execJar = IBMExecDumpProvider.makeJar(jarname, "Main-Class: ", classesNames, classes);
        }
        return execJar;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType() {
        if ($SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType != null) {
            return $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType;
        }
        int[] nArray = new int[DumpType.values().length];
        try {
            nArray[DumpType.HEAP.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.HPROF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.JAVA.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.SYSTEM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JDTLaunchingSAXHandler
    extends DefaultHandler {
        List<String> javaHomes = new ArrayList<String>();
        private String defVM;
        private String type;

        private JDTLaunchingSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("vmSettings")) {
                String[] s;
                String settings = attributes.getValue("defaultVM");
                if (settings != null && (s = settings.split(",")).length >= 3) {
                    this.defVM = s[2];
                }
            } else if (name.equals("vmType")) {
                this.type = attributes.getValue("id");
            } else if (name.equals("vm") && "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(this.type)) {
                String id = attributes.getValue("id");
                String path = attributes.getValue("path");
                if (path != null) {
                    if (id != null && id.equals(this.defVM)) {
                        this.javaHomes.add(0, path);
                    } else {
                        this.javaHomes.add(path);
                    }
                }
            }
        }

        public List<String> getJavaHome() {
            return this.javaHomes;
        }
    }
}

