/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PackagingTypeFilter
implements Predicate<LifecycleMappingMetadata> {
    private List<LifecycleMappingFilter> filters;

    public PackagingTypeFilter(List<MappingMetadataSource> metadataSources, String packagingType) {
        this.filters = metadataSources.stream().flatMap(s -> s.getFilters().stream()).filter(filter -> filter.getPackagingTypes().contains(packagingType)).collect(Collectors.toList());
    }

    @Override
    public boolean test(LifecycleMappingMetadata metadata) {
        return Optional.ofNullable(metadata.getSource()).map(LifecycleMappingMetadataSource::getSource).filter(Bundle.class::isInstance).map(Bundle.class::cast).filter(bundle -> this.filters.stream().anyMatch(filter -> {
            if (filter.getSymbolicName().equals(bundle.getSymbolicName())) {
                Version version = bundle.getVersion();
                return filter.matches(String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro());
            }
            return false;
        })).isPresent();
    }
}

