/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.eclipse.ui.wizards.datatransfer.RecursiveFileFinder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.w3c.dom.Document;

public class JPAProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            RecursiveFileFinder finder = new RecursiveFileFinder("persistence.xml", ignoredDirectories);
            project.accept((IResourceVisitor)finder);
            return finder.getFile() != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
            IProjectFacet JPA_FACET = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");
            if (!facetedProject.hasProjectFacet(JPA_FACET)) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                RecursiveFileFinder finder = new RecursiveFileFinder("persistence.xml", ignoredDirectories);
                project.accept((IResourceVisitor)finder);
                InputStream webXmlStream = finder.getFile().getContents();
                Document doc = dBuilder.parse(webXmlStream);
                webXmlStream.close();
                IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
                aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                String version = doc.getElementById("persistence").getAttribute("version");
                facetedProject.installProjectFacet(JPA_FACET.getVersion(version), (Object)aFacetInstallDataModel, monitor);
            }
        }
        catch (Exception ex) {
            JptJpaUiPlugin.instance().logError(ex);
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return Collections.emptySet();
    }
}

