/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.behaviors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.SetChangeListener;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.behaviors.AbstractHidingBehavior;
import org.eclipse.gef.zest.fx.parts.HiddenNeighborsFeedbackPart;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class NodeHidingBehavior
extends AbstractHidingBehavior {
    private IVisualPart<? extends javafx.scene.Node> hiddenNeighborsFeedbackPart;

    private boolean containsAny(Set<Node> hidden, Set<Node> neighbors) {
        boolean containsAny = false;
        for (Node n : neighbors) {
            if (!hidden.contains(n)) continue;
            containsAny = true;
            break;
        }
        return containsAny;
    }

    protected void createHiddenNeighborsFeedbackPart() {
        if (this.hiddenNeighborsFeedbackPart == null) {
            this.hiddenNeighborsFeedbackPart = new HiddenNeighborsFeedbackPart();
        }
        this.addAnchoreds(Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsFeedbackPart));
    }

    @Override
    protected boolean determineHiddenStatus() {
        return this.getHidingModel().isHidden(this.getHost().getContent());
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        if (this.getHidingModel().hasHiddenNeighbors(this.getHost())) {
            this.createHiddenNeighborsFeedbackPart();
        }
    }

    @Override
    protected void doDeactivate() {
        if (this.getHidingModel().hasHiddenNeighbors(this.getHost())) {
            this.removeHiddenNeighborsFeedbackPart();
        }
        super.doDeactivate();
    }

    protected IVisualPart<? extends javafx.scene.Node> getHiddenNeighborsFeedbackPart() {
        return this.hiddenNeighborsFeedbackPart;
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    @Override
    protected void onHidingModelChange(SetChangeListener.Change<? extends Node> change) {
        super.onHidingModelChange(change);
        HashSet<Node> newHidden = new HashSet<Node>((Collection<Node>)change.getSet());
        HashSet<Node> oldHidden = new HashSet<Node>((Collection<Node>)change.getSet());
        oldHidden.remove(change.getElementAdded());
        oldHidden.add((Node)change.getElementRemoved());
        Node content = this.getHost().getContent();
        Set neighbors = content.getNeighbors();
        if (!this.containsAny(oldHidden, neighbors) && this.containsAny(newHidden, neighbors)) {
            this.createHiddenNeighborsFeedbackPart();
        } else if (this.containsAny(oldHidden, neighbors) && !this.containsAny(newHidden, neighbors)) {
            this.removeHiddenNeighborsFeedbackPart();
        } else if (this.hiddenNeighborsFeedbackPart != null) {
            this.updateHiddenNeighborsFeedbackPart();
        }
    }

    protected void removeHiddenNeighborsFeedbackPart() {
        this.removeAnchoreds(Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsFeedbackPart));
    }

    protected void updateHiddenNeighborsFeedbackPart() {
        this.hiddenNeighborsFeedbackPart.refreshVisual();
    }
}

