/**
 */
package org.eclipse.gef.dot.internal.language.fontname.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gef.dot.internal.language.fontname.FontnamePackage;
import org.eclipse.gef.dot.internal.language.fontname.Gravity;
import org.eclipse.gef.dot.internal.language.fontname.PangoFontName;
import org.eclipse.gef.dot.internal.language.fontname.Stretch;
import org.eclipse.gef.dot.internal.language.fontname.Style;
import org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement;
import org.eclipse.gef.dot.internal.language.fontname.Variant;
import org.eclipse.gef.dot.internal.language.fontname.Weight;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Pango Font Name</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl#getStyleOptionsList <em>Style Options List</em>}</li>
 *   <li>{@link org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl#getFamilies <em>Families</em>}</li>
 *   <li>{@link org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl#getFinalFamily <em>Final Family</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PangoFontNameImpl extends MinimalEObjectImpl.Container implements PangoFontName
{
	/**
	 * The cached value of the '{@link #getStyleOptionsList() <em>Style Options List</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStyleOptionsList()
	 * @generated
	 * @ordered
	 */
	protected EList<StyleOptionsElement> styleOptionsList;

	/**
	 * The cached value of the '{@link #getFamilies() <em>Families</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFamilies()
	 * @generated
	 * @ordered
	 */
	protected EList<String> families;

	/**
	 * The cached value of the '{@link #getFinalFamily() <em>Final Family</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFinalFamily()
	 * @generated
	 * @ordered
	 */
	protected EList<String> finalFamily;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PangoFontNameImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return FontnamePackage.Literals.PANGO_FONT_NAME;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<StyleOptionsElement> getStyleOptionsList()
	{
		if (styleOptionsList == null)
		{
			styleOptionsList = new EObjectContainmentEList<StyleOptionsElement>(StyleOptionsElement.class, this, FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST);
		}
		return styleOptionsList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getFamilies()
	{
		if (families == null)
		{
			families = new EDataTypeUniqueEList<String>(String.class, this, FontnamePackage.PANGO_FONT_NAME__FAMILIES);
		}
		return families;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getFinalFamily()
	{
		if (finalFamily == null)
		{
			finalFamily = new EDataTypeEList<String>(String.class, this, FontnamePackage.PANGO_FONT_NAME__FINAL_FAMILY);
		}
		return finalFamily;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Weight getWeight()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Style getStyle()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variant getVariant()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Stretch getStretch()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Gravity getGravity()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<String> getFontFamilies()
	{
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST:
				return ((InternalEList<?>)getStyleOptionsList()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST:
				return getStyleOptionsList();
			case FontnamePackage.PANGO_FONT_NAME__FAMILIES:
				return getFamilies();
			case FontnamePackage.PANGO_FONT_NAME__FINAL_FAMILY:
				return getFinalFamily();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST:
				getStyleOptionsList().clear();
				getStyleOptionsList().addAll((Collection<? extends StyleOptionsElement>)newValue);
				return;
			case FontnamePackage.PANGO_FONT_NAME__FAMILIES:
				getFamilies().clear();
				getFamilies().addAll((Collection<? extends String>)newValue);
				return;
			case FontnamePackage.PANGO_FONT_NAME__FINAL_FAMILY:
				getFinalFamily().clear();
				getFinalFamily().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST:
				getStyleOptionsList().clear();
				return;
			case FontnamePackage.PANGO_FONT_NAME__FAMILIES:
				getFamilies().clear();
				return;
			case FontnamePackage.PANGO_FONT_NAME__FINAL_FAMILY:
				getFinalFamily().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case FontnamePackage.PANGO_FONT_NAME__STYLE_OPTIONS_LIST:
				return styleOptionsList != null && !styleOptionsList.isEmpty();
			case FontnamePackage.PANGO_FONT_NAME__FAMILIES:
				return families != null && !families.isEmpty();
			case FontnamePackage.PANGO_FONT_NAME__FINAL_FAMILY:
				return finalFamily != null && !finalFamily.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (families: ");
		result.append(families);
		result.append(", finalFamily: ");
		result.append(finalFamily);
		result.append(')');
		return result.toString();
	}

} //PangoFontNameImpl
