/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.mylyn.DLTKDeclarationsFilter;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.internal.ui.scriptview.ToggleLinkingAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.AbstractAutoFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;

public class FocusPackageExplorerAction
extends AbstractAutoFocusViewAction {
    public FocusPackageExplorerAction() {
        super(new InterestFilter(), true, true, true);
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        TextSelection textSelection;
        IModelElement javaElement;
        IModelElement elementToSelect = null;
        if (changedSelection instanceof TextSelection && (javaElement = SelectionConverter.resolveEnclosingElement((IEditorPart)part, (ITextSelection)(textSelection = (TextSelection)changedSelection))) != null) {
            elementToSelect = javaElement;
        }
        if (elementToSelect != null) {
            StructuredSelection currentSelection = (StructuredSelection)viewer.getSelection();
            if (currentSelection.size() <= 1 && elementToSelect instanceof IMember) {
                if (viewer.getContentProvider() instanceof StandardModelElementContentProvider && !((StandardModelElementContentProvider)viewer.getContentProvider()).getProvideMembers()) {
                    elementToSelect = ((IMember)elementToSelect).getSourceModule();
                    return new StructuredSelection((Object)elementToSelect);
                }
                for (ViewerFilter filter : Arrays.asList(viewer.getFilters())) {
                    if (!(filter instanceof DLTKDeclarationsFilter)) continue;
                    elementToSelect = ((IMember)elementToSelect).getSourceModule();
                    return new StructuredSelection((Object)elementToSelect);
                }
            }
            return new StructuredSelection((Object)elementToSelect);
        }
        return null;
    }

    protected void setManualFilteringAndLinkingEnabled(boolean enabled) {
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            ActionContributionItem actionItem;
            IContributionItem item;
            IContributionItem[] iContributionItemArray = ((ScriptExplorerPart)part).getViewSite().getActionBars().getToolBarManager().getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (actionItem = (ActionContributionItem)item).getAction() instanceof ToggleLinkingAction) {
                    actionItem.getAction().setEnabled(enabled);
                }
                ++n2;
            }
            iContributionItemArray = ((ScriptExplorerPart)part).getViewSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (actionItem = (ActionContributionItem)item).getAction().getClass().getSimpleName().equals("ShowFilterDialogAction")) {
                    actionItem.getAction().setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            ((ScriptExplorerPart)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            return ((ScriptExplorerPart)part).isLinkingEnabled();
        }
        return false;
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            viewers.add((StructuredViewer)((ScriptExplorerPart)part).getTreeViewer());
        }
        return viewers;
    }
}

