/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.color;

import org.eclipse.swt.graphics.RGB;

public enum AcceleoColor {
    BLACK(new RGB(0, 0, 0)),
    RED(new RGB(192, 0, 0)),
    COMMENT("org.eclipse.acceleo.comment.color", new RGB(63, 127, 95)),
    DEFAULT("org.eclipse.acceleo.default.color", new RGB(0, 0, 0)),
    FOR("org.eclipse.acceleo.for.color", new RGB(127, 0, 85)),
    IF("org.eclipse.acceleo.if.color", new RGB(127, 0, 85)),
    KEYWORD("org.eclipse.acceleo.keyword.color", new RGB(127, 0, 85)),
    LET("org.eclipse.acceleo.let.color", new RGB(127, 0, 85)),
    LITERAL("org.eclipse.acceleo.literal.color", new RGB(63, 127, 127)),
    MACRO("org.eclipse.acceleo.macro.color", new RGB(192, 0, 0)),
    MODULE_NAME("org.eclipse.acceleo.module.name.color", new RGB(80, 80, 255)),
    OCL_EXPRESSION("org.eclipse.acceleo.ocl.expression.color", new RGB(80, 80, 255)),
    OCL_KEYWORD("org.eclipse.acceleo.ocl.keyword.color", new RGB(80, 80, 255)),
    PROTECTED_AREA("org.eclipse.acceleo.protected.color", new RGB(130, 160, 190)),
    QUERY("org.eclipse.acceleo.query.color", new RGB(127, 0, 85)),
    QUERY_NAME("org.eclipse.acceleo.query.name.color", new RGB(127, 0, 85)),
    QUERY_PARAMETER("org.eclipse.acceleo.query.parameter.color", new RGB(127, 0, 85)),
    QUERY_RETURN("org.eclipse.acceleo.query.return.color", new RGB(127, 0, 85)),
    TEMPLATE("org.eclipse.acceleo.template.color", new RGB(192, 0, 0)),
    TEMPLATE_NAME("org.eclipse.acceleo.template.name.color", new RGB(192, 0, 0)),
    TEMPLATE_OCL_EXPRESSION("org.eclipse.acceleo.template.ocl.expression.color", new RGB(192, 0, 0)),
    TEMPLATE_OCL_KEYWORD("org.eclipse.acceleo.template.ocl.keyword.color", new RGB(192, 0, 0)),
    TEMPLATE_PARAMETER("org.eclipse.acceleo.template.parameter.color", new RGB(192, 0, 0)),
    VARIABLE("org.eclipse.acceleo.variable.color", new RGB(80, 80, 255));

    private String preferenceKey;
    private RGB defaultRGB;

    private AcceleoColor(String preferenceKey, RGB defaultRGB) {
        this.preferenceKey = preferenceKey;
        this.defaultRGB = defaultRGB;
    }

    private AcceleoColor(RGB defaultRGB) {
        this("", defaultRGB);
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public RGB getDefault() {
        return this.defaultRGB;
    }

    public static AcceleoColor getColor(String preferenceKey) {
        if (preferenceKey == null) {
            throw new NullPointerException();
        }
        AcceleoColor[] acceleoColorArray = AcceleoColor.values();
        int n = acceleoColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AcceleoColor color = acceleoColorArray[n2];
            if (preferenceKey.equals(color.getPreferenceKey())) {
                return color;
            }
            ++n2;
        }
        return null;
    }
}

