/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodelimpl.ProfileLoader;
import org.osgi.framework.Bundle;

class CSSProfileImpl
implements CSSProfile {
    String fID = null;
    String fName = null;
    URL fURL = null;
    CSSMetaModel fMetaModel = null;
    String fOwnerPluginID = null;
    boolean fDefault = false;
    boolean fLogging = false;
    private String fRelativeURI = null;

    private CSSProfileImpl() {
    }

    public CSSProfileImpl(String id, URL url) {
        this();
        this.fID = id;
        this.fURL = url;
    }

    CSSProfileImpl(String id, URL url, String relativeURI) {
        this.fID = id;
        this.fURL = url;
        this.fRelativeURI = relativeURI;
    }

    @Override
    public String getProfileID() {
        return this.fID;
    }

    @Override
    public String getProfileName() {
        return this.fName == null ? this.fID : this.fName;
    }

    @Override
    public CSSMetaModel getMetaModel() {
        if (this.fMetaModel == null) {
            try {
                InputStream input = this.getProfileURL().openStream();
                ProfileLoader loader = new ProfileLoader(this.getResourceBundle(), this.getLogging());
                this.fMetaModel = loader.loadProfile(input);
            }
            catch (IOException e) {
                Logger.logException("Cannot open stream for profile", e);
            }
        }
        return this.fMetaModel;
    }

    private ResourceBundle getResourceBundle() {
        IPath[] paths;
        FallbackPropertyResourceBundle resourceBundle = null;
        Bundle bundle = null;
        String pluginID = this.getOwnerPluginID();
        if (pluginID != null && (bundle = Platform.getBundle((String)pluginID)) != null && (paths = this.getResourceBundlePaths()) != null) {
            InputStream inStream = null;
            int i = 0;
            while (i < paths.length && inStream == null) {
                IPath path = paths[i];
                try {
                    try {
                        inStream = FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)true);
                        if (inStream != null) {
                            resourceBundle = new FallbackPropertyResourceBundle(inStream, i + 1 < paths.length ? paths[i + 1] : null);
                        } else {
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        ++i;
                        if (inStream == null) continue;
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            Logger.log(202, e.getMessage(), e);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            Logger.log(202, e.getMessage(), e);
                        }
                    }
                    throw throwable;
                }
                if (inStream == null) continue;
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    Logger.log(202, e.getMessage(), e);
                }
            }
        }
        return resourceBundle;
    }

    private IPath[] getResourceBundlePaths() {
        IPath[] paths = new IPath[]{};
        if (this.fRelativeURI != null) {
            IPath originalPath = Path.fromOSString((String)this.fRelativeURI).removeLastSegments(1);
            String baseName = "cssprofile";
            Vector names = this.calculateBundleNames(baseName, Locale.getDefault());
            int a = 0;
            paths = new IPath[names.size()];
            int i = names.size();
            while (i > 0) {
                IPath path;
                String bundleName = (String)names.get(i - 1);
                paths[a] = path = originalPath.append(bundleName).addFileExtension("properties");
                ++a;
                --i;
            }
        }
        return paths;
    }

    private Vector calculateBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.addElement(baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    @Override
    public URL getProfileURL() {
        return this.fURL;
    }

    void setProfileName(String name) {
        this.fName = name;
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    void setDefault(boolean isDefault) {
        this.fDefault = isDefault;
    }

    @Override
    public String getOwnerPluginID() {
        return this.fOwnerPluginID;
    }

    void setOwnerPluginID(String pluginID) {
        this.fOwnerPluginID = pluginID;
    }

    void setLogging(boolean logging) {
        this.fLogging = logging;
    }

    boolean getLogging() {
        return this.fLogging;
    }

    class FallbackPropertyResourceBundle
    extends PropertyResourceBundle {
        private PropertyResourceBundle fallback;
        private IPath fallbackPath;

        public FallbackPropertyResourceBundle(InputStream stream, IPath fallbackPath) throws IOException {
            super(stream);
            this.fallback = null;
            this.fallbackPath = fallbackPath;
        }

        public String getProperty(String key) {
            String property;
            block21: {
                property = null;
                try {
                    property = this.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    block20: {
                        Bundle bundle;
                        if (this.fallback == null && this.fallbackPath != null && (bundle = Platform.getBundle((String)CSSProfileImpl.this.getOwnerPluginID())) != null) {
                            InputStream stream = null;
                            try {
                                try {
                                    stream = FileLocator.openStream((Bundle)bundle, (IPath)this.fallbackPath, (boolean)true);
                                    if (stream != null) {
                                        this.fallback = new PropertyResourceBundle(stream);
                                    }
                                }
                                catch (IOException iOException) {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException iOException2) {}
                                    }
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (this.fallback == null) break block21;
                    try {
                        property = this.fallback.getString(key);
                    }
                    catch (MissingResourceException missingResourceException2) {}
                }
            }
            return property;
        }
    }
}

