/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.interfaces.delegates.ILabelProviderDelegate;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.AbstractLabelProviderDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;

public class LabelProviderDelegate
extends AbstractLabelProviderDelegate
implements ILabelProviderDelegate,
ILabelDecorator {
    public String getText(final Object element) {
        if (element instanceof IRuntimeModel) {
            final AtomicReference node = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    node.set(((IRuntimeModel)element).getPeerNode());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            String label = Messages.getStringDelegated(node.get(), "ProcessLabelProvider_RootNodeLabel");
            return label != null ? label : Messages.ProcessLabelProvider_RootNodeLabel;
        }
        if (element instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicReference name = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    name.set(node.getName());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            if (name.get() != null && !"".equals(((String)name.get()).trim())) {
                return (String)name.get();
            }
        } else if (element instanceof IModelNode) {
            return ((IModelNode)element).getName();
        }
        return "";
    }

    public Image getImage(final Object element) {
        if (element instanceof IRuntimeModel) {
            return UIPlugin.getImage("OBJ_Process_Root");
        }
        if (element instanceof IProcessContextNode) {
            Image image = null;
            final AtomicBoolean isThread = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IProcessContextNode node = (IProcessContextNode)element;
                    boolean thread = false;
                    if (node.getParent() instanceof IRuntimeModel) {
                        ISysMonitor.SysMonitorContext smc = node.getSysMonitorContext();
                        if (smc != null && Integer.valueOf(1).equals(smc.getProperties().get("ExeType"))) {
                            thread = true;
                        }
                    } else {
                        thread = true;
                    }
                    isThread.set(thread);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            image = UIPlugin.getImage(isThread.get() ? "OBJ_Thread" : "OBJ_Process");
            return image;
        }
        if (element instanceof IModelNode) {
            return UIPlugin.getImage(((IModelNode)element).getImageId());
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

