/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.LoadingPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTi;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameReservation;

public class QVTs2QVTiVisitor
extends AbstractExtendingQVTscheduleVisitor<Element, Object> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull QVTs2QVTi qvts2qvti;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull Transformation asTransformation;
    protected final @NonNull SymbolNameReservation symbolNameReservation;
    protected final @NonNull ImperativeTransformation iTransformation;
    protected final @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> asTypedModel2iTypedModel;
    protected final @NonNull List<@NonNull TypedModel> checkableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull List<@NonNull TypedModel> checkableAndEnforceableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull List<@NonNull TypedModel> enforceableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull Map<@NonNull Partition, @NonNull AbstractPartition2Mapping> partition2partition2mapping = new HashMap<Partition, AbstractPartition2Mapping>();
    private @Nullable Set<@NonNull String> reservedNames = null;
    private @NonNull Map<@NonNull Operation, @NonNull Operation> qvtmOperation2qvtiOperation = new HashMap<Operation, Operation>();
    private final @NonNull Set<@NonNull Transformation> otherTransformations = new HashSet<Transformation>();
    private final @NonNull Map<@NonNull String, @NonNull Operation> name2operation = new HashMap<String, Operation>();
    private TypedModel iMiddleTypedModel = null;
    private @NonNull Map<@NonNull ClassDatum, @NonNull Function> classDatum2keyFunction = new HashMap<ClassDatum, Function>();

    public QVTs2QVTiVisitor(@NonNull QVTs2QVTi qvts2qvti, @NonNull SymbolNameReservation symbolNameReservation, @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> asTypedModel2iTypedModel) {
        super(null);
        this.scheduleManager = qvts2qvti.getScheduleManager();
        this.qvts2qvti = qvts2qvti;
        this.environmentFactory = qvts2qvti.getEnvironmentFactory();
        this.helper = new QVTimperativeHelper(this.environmentFactory);
        this.asTransformation = QVTbaseUtil.getContainingTransformation((EObject)((EObject)asTypedModel2iTypedModel.keySet().iterator().next()));
        this.symbolNameReservation = symbolNameReservation;
        this.iTransformation = QVTimperativeUtil.getContainingTransformation((EObject)((EObject)asTypedModel2iTypedModel.values().iterator().next()));
        this.asTypedModel2iTypedModel = asTypedModel2iTypedModel;
        for (TypedModel iTypedModel : asTypedModel2iTypedModel.values()) {
            if (!iTypedModel.isIsTrace()) continue;
            this.iMiddleTypedModel = iTypedModel;
        }
    }

    private void accumulateOperations(@NonNull Transformation transformation) {
        if (this.otherTransformations.add(transformation)) {
            TreeIterator tit = transformation.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Operation)) continue;
                Operation operation = (Operation)eObject;
                String name = String.valueOf(operation);
                this.name2operation.put(name, operation);
            }
        }
    }

    public @Nullable Operation create(@Nullable Operation pOperation) {
        if (pOperation == null) {
            return null;
        }
        Operation iOperation = this.qvtmOperation2qvtiOperation.get(pOperation);
        if (iOperation == null) {
            Transformation containingTransformation = QVTbaseUtil.basicGetContainingTransformation((EObject)pOperation);
            if (containingTransformation == this.asTransformation) {
                iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                assert (iOperation != null);
                this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                this.iTransformation.getOwnedOperations().add(iOperation);
            } else {
                Operation otherOperation;
                if (containingTransformation != null) {
                    this.accumulateOperations(containingTransformation);
                }
                if ((otherOperation = this.name2operation.get(pOperation.toString())) != null) {
                    iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                    assert (iOperation != null);
                    this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                    this.iTransformation.getOwnedOperations().add(iOperation);
                } else {
                    iOperation = pOperation;
                    this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                }
            }
        }
        return iOperation;
    }

    private void createKeyFunctions(@NonNull Map<@NonNull ClassDatum, Set<@NonNull PropertyDatum>> keyedClassDatum2propertyDatums) {
        ArrayList<@NonNull ClassDatum> classDatums = new ArrayList<ClassDatum>(keyedClassDatum2propertyDatums.keySet());
        Collections.sort(classDatums, NameUtil.NAMEABLE_COMPARATOR);
        for (ClassDatum classDatum : classDatums) {
            Class primaryClass = classDatum.getPrimaryClass();
            ArrayList<@NonNull E> propertyDatums = new ArrayList(keyedClassDatum2propertyDatums.get(classDatum));
            Collections.sort(propertyDatums, NameUtil.NAMEABLE_COMPARATOR);
            String functionName = this.scheduleManager.getNameGenerator().createKeyFunctionName(classDatum);
            ArrayList<@NonNull FunctionParameter> asParameters = new ArrayList<FunctionParameter>();
            ArrayList<@NonNull ShadowPart> asShadowParts = new ArrayList<ShadowPart>();
            for (PropertyDatum propertyDatum : propertyDatums) {
                Property keyProperty = QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum);
                FunctionParameter cParameter = this.qvts2qvti.createFunctionParameter((TypedElement)keyProperty);
                asParameters.add(cParameter);
                ShadowPart asShadowPart = this.qvts2qvti.createShadowPart(keyProperty, (OCLExpression)this.qvts2qvti.createVariableExp((VariableDeclaration)cParameter));
                asShadowParts.add(asShadowPart);
            }
            Collections.sort(asParameters, NameUtil.NAMEABLE_COMPARATOR);
            QVTbaseUtil.getContextVariable((StandardLibrary)this.getStandardLibrary(), (Transformation)this.iTransformation, (Transformation)this.asTransformation);
            Function asFunction = this.qvts2qvti.createFunction(functionName, (Type)primaryClass, true, asParameters);
            this.iTransformation.getOwnedOperations().add(asFunction);
            OCLExpression asShadowExp = this.qvts2qvti.createShadowExp(primaryClass, asShadowParts);
            asFunction.setQueryExpression(asShadowExp);
            this.classDatum2keyFunction.put(classDatum, asFunction);
        }
    }

    public void createPartition2Mapping(@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis> partitionAnalysis) {
        Partition partition = partitionAnalysis.getPartition();
        AbstractPartition2Mapping partition2mapping = this.partition2partition2mapping.get(partition);
        assert (partition2mapping == null) : "Re-AbstractPartition2Mapping for " + partition;
        if (partition instanceof LoadingPartition) {
            String mappingName = partition.getSymbolName();
            assert (mappingName != null);
            EntryPoint entryPoint = this.qvts2qvti.createEntryPoint(mappingName);
            entryPoint.setTargetName(((LoadingPartition)partition).getReferredLoadingRegion().getTargetName());
            for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.asTransformation)) {
                if (this.scheduleManager.isInput(typedModel) && !typedModel.isIsPrimitive()) {
                    entryPoint.getInputTypedModels().add((Object)this.asTypedModel2iTypedModel.get(typedModel));
                }
                if (!this.scheduleManager.isOutput(typedModel)) continue;
                entryPoint.getOutputTypedModels().add((Object)this.asTypedModel2iTypedModel.get(typedModel));
            }
            partition2mapping = new LoadingPartition2Mapping(this, entryPoint, (LoadingPartition)partition);
        } else {
            String mappingName = partition.getSymbolName();
            assert (mappingName != null);
            Mapping mapping = this.qvts2qvti.createMapping(mappingName);
            partition2mapping = new BasicPartition2Mapping(this, mapping, (MappingPartitionAnalysis)partitionAnalysis);
        }
        partition2mapping.synthesizeLocalStatements();
        this.partition2partition2mapping.put(partition, partition2mapping);
        this.iTransformation.getRule().add((Object)partition2mapping.getMapping());
        this.visitPartition(partition);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<@NonNull ClassDatum, Set<@NonNull PropertyDatum>> gatherKeyCalls(List<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> sortedPartitionAnalyses) {
        HashMap<@NonNull ClassDatum, Set<@NonNull PropertyDatum>> keyedClassDatum2propertyDatums = new HashMap<ClassDatum, Set<PropertyDatum>>();
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : sortedPartitionAnalyses) {
            Partition partition = partitionAnalysis.getPartition();
            for (Node node : partition.getPartialNodes()) {
                if (!(node instanceof KeyedValueNode)) continue;
                KeyedValueNode keyedValueNode = (KeyedValueNode)node;
                ClassDatum classDatum = keyedValueNode.getClassDatumValue();
                assert (classDatum != null);
                HashSet<@NonNull PropertyDatum> propertyDatums = new HashSet<PropertyDatum>();
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)keyedValueNode)) {
                    if (!(edge instanceof KeyPartEdge)) continue;
                    KeyPartEdge keyPartEdge = (KeyPartEdge)edge;
                    PropertyDatum propertyDatum = QVTscheduleUtil.getReferredPart((KeyPartEdge)keyPartEdge);
                    assert (propertyDatum.isKey());
                    boolean wasAdded = propertyDatums.add(propertyDatum);
                    assert (wasAdded);
                }
                @NonNull Set oldPropertyDatums = keyedClassDatum2propertyDatums.put(classDatum, propertyDatums);
                assert (oldPropertyDatums == null || oldPropertyDatums.equals(propertyDatums));
            }
        }
        return keyedClassDatum2propertyDatums;
    }

    protected void gatherReservedPackageNames(@NonNull Set<@NonNull String> reservedNames, @NonNull Iterable<Package> asPackages) {
        for (Package asPackage : asPackages) {
            reservedNames.add((String)ClassUtil.nonNullState((Object)asPackage.getName()));
            this.gatherReservedClassNames(reservedNames, asPackage.getOwnedClasses());
            this.gatherReservedPackageNames(reservedNames, asPackage.getOwnedPackages());
        }
    }

    protected void gatherReservedClassNames(@NonNull Set<@NonNull String> reservedNames, @NonNull Iterable<Class> asClasses) {
        for (Class asClass : asClasses) {
            reservedNames.add((String)ClassUtil.nonNullState((Object)asClass.getName()));
        }
    }

    public @NonNull ConnectionManager getConnectionManager() {
        return this.scheduleManager.getConnectionManager();
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull Operation getEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @NonNull QVTimperativeHelper getHelper() {
        return this.helper;
    }

    public @NonNull ImperativeTransformation getImperativeTransformation() {
        return this.iTransformation;
    }

    public @NonNull Function getKeyFunction(@NonNull ClassDatum classDatum) {
        return (Function)ClassUtil.nonNullState((Object)this.classDatum2keyFunction.get(classDatum));
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull Operation getNotEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"<>");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @NonNull Transformation getOriginalTransformation() {
        return this.asTransformation;
    }

    public @NonNull AbstractPartition2Mapping getPartition2Mapping(@NonNull Partition partition) {
        Partition mergedPartition = QVTscheduleUtil.getMergedPartition((Partition)partition);
        AbstractPartition2Mapping region2mapping = this.partition2partition2mapping.get(mergedPartition);
        assert (region2mapping != null) : "No AbstractRegion2Mapping for " + mergedPartition;
        return region2mapping;
    }

    public @NonNull ProblemHandler getProblemHandler() {
        return this.qvts2qvti.getProblemHandler();
    }

    public @Nullable TypedModel getQVTiTypedModel(@Nullable TypedModel asTypedModel) {
        if (asTypedModel == null) {
            assert (this.iMiddleTypedModel != null);
            return this.iMiddleTypedModel;
        }
        return this.asTypedModel2iTypedModel.get(asTypedModel);
    }

    public @NonNull Set<@NonNull String> getReservedNames() {
        Set<@NonNull String> reservedNames2 = this.reservedNames;
        if (reservedNames2 == null) {
            this.reservedNames = reservedNames2 = new HashSet<String>();
            Package standardLibraryPackage = this.getStandardLibrary().getOclAnyType().getOwningPackage();
            this.gatherReservedPackageNames(reservedNames2, Collections.singletonList(standardLibraryPackage));
            reservedNames2.add((String)ClassUtil.nonNull((Object)this.asTransformation.getName()));
            for (TypedModel typedModel : this.asTransformation.getModelParameter()) {
                reservedNames2.add((String)ClassUtil.nonNullState((Object)typedModel.getName()));
                this.gatherReservedPackageNames(reservedNames2, (Iterable<Package>)typedModel.getUsedPackage());
            }
            for (Operation operation : this.asTransformation.getOwnedOperations()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)operation.getName()));
            }
            for (Property property : this.asTransformation.getOwnedProperties()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)property.getName()));
            }
        }
        return reservedNames2;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @NonNull String reserveSymbolName(@NonNull SymbolNameBuilder symbolNameBuilder, @NonNull Object object) {
        return this.symbolNameReservation.reserveSymbolName(symbolNameBuilder, object);
    }

    public @Nullable Element visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public Element visitEdge(@NonNull Edge edge) {
        return this.visiting((Visitable)edge);
    }

    public Element visitEdgeConnection(@NonNull EdgeConnection edgeConnection) {
        return this.visiting((Visitable)edgeConnection);
    }

    public @Nullable Element visitMappingRegion(@NonNull MappingRegion mappingRegion) {
        return this.visiting((Visitable)mappingRegion);
    }

    public Element visitNavigableEdge(@NonNull NavigableEdge navigableEdge) {
        return this.visitEdge((Edge)navigableEdge);
    }

    public Element visitNode(@NonNull Node node) {
        return this.visiting((Visitable)node);
    }

    public Element visitNodeConnection(@NonNull NodeConnection nodeConnection) {
        return this.visiting((Visitable)nodeConnection);
    }

    public @Nullable Element visitOperationRegion(@NonNull OperationRegion operationRegion) {
        return this.visiting((Visitable)operationRegion);
    }

    public @Nullable Element visitPartition(@NonNull Partition partition) {
        AbstractPartition2Mapping partition2mapping = this.getPartition2Mapping(partition);
        return partition2mapping.getMapping();
    }

    public Element visitRegion(@NonNull Region region) {
        return this.visiting((Visitable)region);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Element visitRootRegion(@NonNull RootRegion rootRegion) {
        Partition partition;
        RootPartitionAnalysis rootPartitionAnalysis = this.scheduleManager.getRootPartitionAnalysis(rootRegion);
        List<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> allPartitionAnalyses = CompilerUtil.gatherPartitionAnalyses(rootPartitionAnalysis, new ArrayList<PartialRegionAnalysis<PartitionsAnalysis>>());
        @NonNull @NonNull ArrayList sortedPartitionAnalyses = Lists.newArrayList(allPartitionAnalyses);
        Collections.sort(sortedPartitionAnalyses, EarliestPartitionComparator.INSTANCE);
        Map<@NonNull ClassDatum, Set<@NonNull PropertyDatum>> keyedClassDatum2propertyDatums = this.gatherKeyCalls(sortedPartitionAnalyses);
        this.createKeyFunctions(keyedClassDatum2propertyDatums);
        for (PartialRegionAnalysis partitionAnalysis : sortedPartitionAnalyses) {
            partition = partitionAnalysis.getPartition();
            if (CompilerUtil.isAbstract(partition)) continue;
            this.createPartition2Mapping(partitionAnalysis);
        }
        for (PartialRegionAnalysis partitionAnalysis : sortedPartitionAnalyses) {
            partition = partitionAnalysis.getPartition();
            if (CompilerUtil.isAbstract(partition)) continue;
            AbstractPartition2Mapping partition2Mapping = this.getPartition2Mapping(partition);
            partition2Mapping.synthesizeCallStatements();
        }
        return null;
    }

    public Element visitVariableNode(@NonNull VariableNode variableNode) {
        return this.visitNode((Node)variableNode);
    }

    public static class EarliestPartitionComparator
    implements Comparator<PartialRegionAnalysis<PartitionsAnalysis>> {
        public static final @NonNull EarliestPartitionComparator INSTANCE = new EarliestPartitionComparator();

        @Override
        public int compare(@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis> o1, @NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis> o2) {
            int i2;
            int i1 = o1.getPartition().getFirstPass();
            if (i1 != (i2 = o2.getPartition().getFirstPass())) {
                return i1 - i2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

