/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.plugin;

import java.util.Hashtable;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.ui.internal.JptUIPlugin;
import org.eclipse.jpt.jaxb.ui.internal.InternalJaxbWorkbench;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.BundleContext;

public class JptJaxbUiPlugin
extends JptUIPlugin {
    private final Hashtable<IWorkbench, InternalJaxbWorkbench> jaxbWorkbenches = new Hashtable();
    private static JptJaxbUiPlugin INSTANCE;

    public static JptJaxbUiPlugin instance() {
        return INSTANCE;
    }

    protected void setInstance(JptPlugin plugin) {
        INSTANCE = (JptJaxbUiPlugin)plugin;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.disposeJaxbWorkbenches();
        }
        finally {
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalJaxbWorkbench getJaxbWorkbench(IWorkbench workbench) {
        Hashtable<IWorkbench, InternalJaxbWorkbench> hashtable = this.jaxbWorkbenches;
        synchronized (hashtable) {
            return this.getJaxbWorkbench_(workbench);
        }
    }

    private InternalJaxbWorkbench getJaxbWorkbench_(IWorkbench workbench) {
        InternalJaxbWorkbench jaxbWorkbench = this.jaxbWorkbenches.get(workbench);
        if (jaxbWorkbench == null && this.isActive()) {
            jaxbWorkbench = this.buildJaxbWorkbench(workbench);
            this.jaxbWorkbenches.put(workbench, jaxbWorkbench);
        }
        return jaxbWorkbench;
    }

    private InternalJaxbWorkbench buildJaxbWorkbench(IWorkbench workbench) {
        return new InternalJaxbWorkbench(workbench);
    }

    private void disposeJaxbWorkbenches() {
        for (InternalJaxbWorkbench jaxbWorkbench : this.jaxbWorkbenches.values()) {
            try {
                jaxbWorkbench.dispose();
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        this.jaxbWorkbenches.clear();
    }
}

