/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt.action;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.table.swt.action.AbstractMoveRowAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MoveRowUpAction
extends AbstractMoveRowAction {
    public static final String ACTION_ID = "org.eclipse.emfforms.action.tablecontrol.move_row_up";
    public static final String DEFAULT_KEYBINDING = "M1+M2+ARROW_UP";

    public MoveRowUpAction(TableRendererViewerActionContext actionContext) {
        super(actionContext);
    }

    public String getId() {
        return ACTION_ID;
    }

    public void execute() {
        List<?> containments = this.getContainments();
        List<Object> moveUpList = Arrays.asList(((IStructuredSelection)this.getTableViewer().getSelection()).toArray());
        MoveRowUpAction.sortSelectionBasedOnIndex(moveUpList, containments);
        EditingDomain editingDomain = this.getActionContext().getEditingDomain();
        EStructuralFeature.Setting setting = this.getActionContext().getSetting();
        EObject eObject = setting.getEObject();
        EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
        List commands = moveUpList.stream().map(moveUpObject -> {
            int currentIndex = containments.indexOf(moveUpObject);
            if (currentIndex <= 0) {
                return null;
            }
            return new MoveCommand(editingDomain, eObject, eStructuralFeature, currentIndex, currentIndex - 1);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        editingDomain.getCommandStack().execute((Command)new CompoundCommand(commands));
        this.getTableViewer().refresh();
    }

    @Override
    public boolean canExecute() {
        List<?> containments = this.getContainments();
        List<Object> moveUpList = Arrays.asList(((IStructuredSelection)this.getTableViewer().getSelection()).toArray());
        if (moveUpList.isEmpty()) {
            return false;
        }
        MoveRowUpAction.sortSelectionBasedOnIndex(moveUpList, containments);
        return containments.indexOf(moveUpList.get(0)) > 0 && super.canExecute();
    }
}

