/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionEvent;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionImpl;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.collection.ArrayIterator;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;

public class CDORemoteSessionManagerImpl
extends Container<CDORemoteSession>
implements InternalCDORemoteSessionManager {
    private static final CDORemoteSession[] NO_REMOTE_SESSIONS = new CDORemoteSession[0];
    private InternalCDOSession localSession;
    private boolean forceSubscription;
    private boolean subscribed;
    private Map<Integer, CDORemoteSession> remoteSessions = new HashMap<Integer, CDORemoteSession>();

    @Override
    public InternalCDOSession getLocalSession() {
        return this.localSession;
    }

    @Override
    public void setLocalSession(InternalCDOSession localSession) {
        this.localSession = localSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDORemoteSession[] getRemoteSessions() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (this.localSession.isActive()) {
                if (this.subscribed) {
                    Collection<CDORemoteSession> values = this.remoteSessions.values();
                    return values.toArray(new CDORemoteSession[values.size()]);
                }
                List<CDORemoteSession> loadedRemoteSessions = this.localSession.getSessionProtocol().getRemoteSessions(this, false);
                return loadedRemoteSessions.toArray(new CDORemoteSession[loadedRemoteSessions.size()]);
            }
            return NO_REMOTE_SESSIONS;
        }
    }

    public CDORemoteSession[] getElements() {
        return this.getRemoteSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubscribed() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.subscribed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isForceSubscription() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.forceSubscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForceSubscription(boolean forceSubscription) {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            this.forceSubscription = forceSubscription;
            if (forceSubscription) {
                if (!this.subscribed) {
                    events = this.subscribe();
                }
            } else if (!this.hasListeners()) {
                events = this.unsubscribe();
            }
        }
        this.fireEvents(events);
    }

    @Override
    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, CDORemoteSession ... recipients) {
        return this.sendMessage(message, (Iterator<CDORemoteSession>)new ArrayIterator((Object[])recipients));
    }

    @Override
    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, Collection<CDORemoteSession> recipients) {
        return this.sendMessage(message, recipients.iterator());
    }

    private Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, Iterator<CDORemoteSession> recipients) {
        ArrayList<CDORemoteSession> subscribed = new ArrayList<CDORemoteSession>();
        while (recipients.hasNext()) {
            CDORemoteSession recipient = recipients.next();
            if (!recipient.isSubscribed()) continue;
            subscribed.add(recipient);
        }
        if (subscribed.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Integer> sessionIDs = this.localSession.getSessionProtocol().sendRemoteMessage(message, subscribed);
        HashSet<CDORemoteSession> result = new HashSet<CDORemoteSession>();
        for (CDORemoteSession recipient : subscribed) {
            if (!sessionIDs.contains(recipient.getSessionID())) continue;
            result.add(recipient);
        }
        return result;
    }

    @Override
    public InternalCDORemoteSession createRemoteSession(int sessionID, String userID, boolean subscribed) {
        CDORemoteSessionImpl remoteSession = new CDORemoteSessionImpl(this, sessionID, userID);
        remoteSession.setSubscribed(subscribed);
        return remoteSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionOpened(int sessionID, String userID) {
        InternalCDORemoteSession remoteSession = this.createRemoteSession(sessionID, userID, false);
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            this.remoteSessions.put(sessionID, remoteSession);
        }
        this.fireElementAddedEvent(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionClosed(int sessionID) {
        CDORemoteSession remoteSession = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            remoteSession = this.remoteSessions.remove(sessionID);
        }
        if (remoteSession != null) {
            this.fireElementRemovedEvent(remoteSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionSubscribed(int sessionID, boolean subscribed) {
        SubscriptionChangedEventImpl event = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            InternalCDORemoteSession remoteSession = (InternalCDORemoteSession)this.remoteSessions.get(sessionID);
            if (remoteSession != null) {
                remoteSession.setSubscribed(subscribed);
                event = new SubscriptionChangedEventImpl(remoteSession, subscribed);
            }
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionMessage(int sessionID, final CDORemoteSessionMessage message) {
        CDORemoteSessionEvent.MessageReceived event = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            final CDORemoteSessionManagerImpl source = this;
            final InternalCDORemoteSession remoteSession = (InternalCDORemoteSession)this.remoteSessions.get(sessionID);
            if (remoteSession != null) {
                event = new CDORemoteSessionEvent.MessageReceived(){

                    @Override
                    public CDORemoteSessionManager getSource() {
                        return source;
                    }

                    @Override
                    public CDORemoteSession getRemoteSession() {
                        return remoteSession;
                    }

                    @Override
                    public CDORemoteSessionMessage getMessage() {
                        return message;
                    }
                };
            }
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firstListenerAdded() {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (!this.subscribed) {
                events = this.subscribe();
            }
        }
        this.fireEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lastListenerRemoved() {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (!this.forceSubscription) {
                events = this.unsubscribe();
            }
        }
        this.fireEvents(events);
    }

    private IEvent[] subscribe() {
        List<CDORemoteSession> result = this.localSession.getSessionProtocol().getRemoteSessions(this, true);
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession remoteSession : result) {
            this.remoteSessions.put(remoteSession.getSessionID(), remoteSession);
            event.addDelta((Object)remoteSession, IContainerDelta.Kind.ADDED);
        }
        this.subscribed = true;
        IEvent[] events = new IEvent[]{new LocalSubscriptionChangedEventImpl(true), event.isEmpty() ? null : event};
        return events;
    }

    private IEvent[] unsubscribe() {
        if (this.localSession.isActive()) {
            this.localSession.getSessionProtocol().unsubscribeRemoteSessions();
        }
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession remoteSession : this.remoteSessions.values()) {
            event.addDelta((Object)remoteSession, IContainerDelta.Kind.REMOVED);
        }
        this.remoteSessions.clear();
        this.subscribed = false;
        IEvent[] events = new IEvent[]{new LocalSubscriptionChangedEventImpl(false), event.isEmpty() ? null : event};
        return events;
    }

    private void fireEvents(IEvent[] events) {
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                IEvent event = events[i];
                if (event != null) {
                    this.fireEvent(event);
                }
                ++i;
            }
        }
    }

    private final class LocalSubscriptionChangedEventImpl
    extends Event
    implements CDORemoteSessionManager.LocalSubscriptionChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean subscribed;

        public LocalSubscriptionChangedEventImpl(boolean subscribed) {
            super((INotifier)CDORemoteSessionManagerImpl.this);
            this.subscribed = subscribed;
        }

        @Override
        public CDORemoteSessionManager getSource() {
            return (CDORemoteSessionManager)super.getSource();
        }

        @Override
        public boolean isSubscribed() {
            return this.subscribed;
        }
    }

    private final class SubscriptionChangedEventImpl
    extends Event
    implements CDORemoteSessionEvent.SubscriptionChanged {
        private static final long serialVersionUID = 1L;
        private InternalCDORemoteSession remoteSession;
        private boolean subscribed;

        public SubscriptionChangedEventImpl(InternalCDORemoteSession remoteSession, boolean subscribed) {
            super((INotifier)CDORemoteSessionManagerImpl.this);
            this.remoteSession = remoteSession;
            this.subscribed = subscribed;
        }

        @Override
        public CDORemoteSessionManager getSource() {
            return (CDORemoteSessionManager)super.getSource();
        }

        @Override
        public CDORemoteSession getRemoteSession() {
            return this.remoteSession;
        }

        @Override
        public boolean isSubscribed() {
            return this.subscribed;
        }
    }
}

