/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.compare;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.compare.CDOCompare;
import org.eclipse.emf.cdo.compare.CDOCompareUtil;
import org.eclipse.emf.cdo.compare.CDOComparisonScope;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.transaction.CDOTransactionOpener;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.ui.internal.compare.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewOpener;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonEditorInput;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public final class CDOCompareEditorUtil {
    @Deprecated
    public static final Image COMPARE_IMAGE = null;
    public static final String PROP_COMPARISON_LABEL = "comparison.label";
    public static final String PROP_COMPARISON_IMAGE = "comparison.image";
    private static final ThreadLocal<String> COMPARISON_TITLE = new ThreadLocal();
    private static final ThreadLocal<Boolean> ACTIVATE_EDITOR = new ThreadLocal();
    private static final ThreadLocal<Consumer<Input>> INPUT_CONSUMER = new ThreadLocal();
    private static final ThreadLocal<Boolean> SUPPRESS_COMMIT = new ThreadLocal();
    private static final ThreadLocal<List<Runnable>> DISPOSE_RUNNABLES = new ThreadLocal();
    private static Image compareImage;

    private CDOCompareEditorUtil() {
    }

    public static Image compareImage() {
        if (compareImage == null) {
            compareImage = OM.getImage("icons/compare.gif");
        }
        return compareImage;
    }

    public static void closeTransactionAfterCommit(CDOTransaction transaction) {
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

            public void rolledBackTransaction(CDOTransaction transaction) {
                this.closeTransaction(transaction);
            }

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                this.closeTransaction(transaction);
            }

            private void closeTransaction(final CDOTransaction transaction) {
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        transaction.close();
                    }
                });
            }
        });
    }

    public static void closeEditorWithTransaction(final CDOTransaction transaction) {
        final IEditorPart[] result = new IEditorPart[1];
        final IWorkbenchPage page = UIUtil.getActiveWorkbenchPage();
        IPartListener listener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof CompareEditor) {
                    result[0] = (IEditorPart)part;
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == result[0]) {
                    transaction.close();
                    page.removePartListener((IPartListener)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        page.addPartListener(listener);
        transaction.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                if (result[0] != null) {
                    UIUtil.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            page.closeEditor(result[0], false);
                        }
                    });
                }
            }
        });
    }

    public static boolean openEditor(CDOViewOpener viewOpener, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint, CDOView[] originView, boolean activate) {
        return CDOCompareEditorUtil.openEditor(viewOpener, null, leftPoint, rightPoint, originView, activate);
    }

    public static boolean openEditor(CDOViewOpener viewOpener, CDOTransactionOpener transactionOpener, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint, CDOView[] originView, boolean activate) {
        ACTIVATE_EDITOR.set(activate);
        try {
            boolean bl = CDOCompareEditorUtil.openDialog(viewOpener, transactionOpener, leftPoint, rightPoint, originView);
            return bl;
        }
        finally {
            ACTIVATE_EDITOR.remove();
        }
    }

    public static boolean openEditor(CDOCommitInfo rightCommitInfo, CDOBranchPoint leftPoint, boolean activate) {
        ACTIVATE_EDITOR.set(activate);
        try {
            boolean bl = CDOCompareEditorUtil.openDialog(rightCommitInfo, leftPoint);
            return bl;
        }
        finally {
            ACTIVATE_EDITOR.remove();
        }
    }

    public static boolean openEditor(CDOCommitInfo commitInfo, boolean activate) {
        ACTIVATE_EDITOR.set(activate);
        try {
            boolean bl = CDOCompareEditorUtil.openDialog(commitInfo);
            return bl;
        }
        finally {
            ACTIVATE_EDITOR.remove();
        }
    }

    public static boolean openEditor(CDOView leftView, CDOView rightView, CDOView[] originView, boolean activate) {
        ACTIVATE_EDITOR.set(activate);
        try {
            boolean bl = CDOCompareEditorUtil.openDialog(leftView, rightView, originView);
            return bl;
        }
        finally {
            ACTIVATE_EDITOR.remove();
        }
    }

    public static boolean openEditor(CDOView leftView, CDOView rightView, Set<CDOID> affectedIDs, boolean activate) {
        ACTIVATE_EDITOR.set(activate);
        try {
            boolean bl = CDOCompareEditorUtil.openDialog(leftView, rightView, affectedIDs);
            return bl;
        }
        finally {
            ACTIVATE_EDITOR.remove();
        }
    }

    public static boolean openDialog(CDOSession session, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint) {
        return CDOCompareEditorUtil.openDialog((CDOViewOpener)session, leftPoint, rightPoint, null);
    }

    public static boolean openDialog(CDOViewOpener viewOpener, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint, CDOView[] originView) {
        return CDOCompareEditorUtil.openDialog(viewOpener, null, leftPoint, rightPoint, originView);
    }

    public static boolean openDialog(CDOViewOpener viewOpener, CDOTransactionOpener transactionOpener, CDOBranchPoint leftPoint, CDOBranchPoint rightPoint, CDOView[] originView) {
        Boolean activateEditor = ACTIVATE_EDITOR.get();
        final CDOView[] leftAndRightView = new CDOView[2];
        CDOCompareEditorUtil.addDisposeRunnables(new Runnable(){

            @Override
            public void run() {
                LifecycleUtil.deactivate((Object)leftAndRightView[0]);
                LifecycleUtil.deactivate((Object)leftAndRightView[1]);
            }
        });
        try {
            ResourceSetImpl leftResourceSet = new ResourceSetImpl();
            leftAndRightView[0] = viewOpener.openView(leftPoint, (ResourceSet)leftResourceSet);
            ResourceSetImpl rightResourceSet = new ResourceSetImpl();
            if (transactionOpener != null) {
                rightPoint = rightPoint.getBranch().getHead();
                leftAndRightView[1] = transactionOpener.openTransaction(rightPoint, (ResourceSet)rightResourceSet);
            } else {
                leftAndRightView[1] = viewOpener.openView(rightPoint, (ResourceSet)rightResourceSet);
            }
            boolean bl = CDOCompareEditorUtil.openDialog(leftAndRightView[0], leftAndRightView[1], originView, viewOpener);
            return bl;
        }
        finally {
            if (activateEditor == null) {
                List<Runnable> list = CDOCompareEditorUtil.removeDisposeRunnables();
                CDOCompareEditorUtil.runDisposeRunnables(list);
            }
        }
    }

    public static boolean openDialog(CDOCommitInfo rightCommitInfo, CDOBranchPoint leftPoint) {
        CDORepositoryInfo repositoryInfo = (CDORepositoryInfo)rightCommitInfo.getCommitInfoManager().getRepository();
        CDOSession session = repositoryInfo.getSession();
        return CDOCompareEditorUtil.openDialog(session, leftPoint, (CDOBranchPoint)rightCommitInfo);
    }

    public static boolean openDialog(CDOCommitInfo commitInfo) {
        long previousTimeStamp = commitInfo.getPreviousTimeStamp();
        if (previousTimeStamp == 0L) {
            return false;
        }
        CDOBranchPoint previous = CDOBranchUtil.normalizeBranchPoint((CDOBranch)commitInfo.getBranch(), (long)previousTimeStamp);
        return CDOCompareEditorUtil.openDialog(commitInfo, previous);
    }

    public static boolean openDialog(CDOView leftView, CDOView rightView, CDOView[] originView) {
        return CDOCompareEditorUtil.openDialog(leftView, rightView, originView, CDOCompareUtil.DEFAULT_VIEW_OPENER);
    }

    public static boolean openDialog(CDOView leftView, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
        Input input = CDOCompareEditorUtil.createComparisonInput(leftView, rightView, originView, viewOpener);
        return CDOCompareEditorUtil.openDialog(input, rightView);
    }

    public static boolean openDialog(CDOView leftView, CDOView rightView, Set<CDOID> affectedIDs) {
        Input input = CDOCompareEditorUtil.createComparisonInput(leftView, rightView, affectedIDs);
        return CDOCompareEditorUtil.openDialog(input, rightView);
    }

    public static boolean openDialog(final Input input, final CDOView rightView) {
        if (input == null) {
            UIUtil.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = UIUtil.getShell();
                    MessageDialog.openInformation((Shell)shell, (String)"Compare", (String)"There are no differences between the selected inputs.");
                }
            });
            return false;
        }
        final Boolean activateEditor = ACTIVATE_EDITOR.get();
        if (activateEditor != null) {
            List<Runnable> disposeRunnables = CDOCompareEditorUtil.removeDisposeRunnables();
            input.setDisposeRunnables(disposeRunnables);
            UIUtil.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompareUI.openCompareEditor((CompareEditorInput)input, (boolean)activateEditor);
                }
            });
        } else {
            BasicEList differences = new BasicEList();
            UIUtil.getDisplay().syncExec(new Runnable((EList)differences){
                private final /* synthetic */ EList val$differences;
                {
                    this.val$differences = eList;
                }

                @Override
                public void run() {
                    CompareUI.openCompareDialog((CompareEditorInput)input);
                    if (rightView instanceof InternalCDOTransaction) {
                        Comparison comparison = input.getComparison();
                        this.val$differences.addAll((Collection)comparison.getDifferences());
                    }
                }
            });
            if (!differences.isEmpty() && rightView instanceof InternalCDOTransaction && !CDOCompareEditorUtil.handleMerges((InternalCDOTransaction)rightView, (EList<Diff>)differences)) {
                return false;
            }
        }
        return input.isOK();
    }

    public static Input createComparisonInput(CDOView leftView, CDOView rightView, CDOView[] originView, CDOViewOpener viewOpener) {
        Comparison comparison = CDOCompareUtil.compare((CDOView)leftView, (CDOView)rightView, (CDOView[])originView, (CDOViewOpener)viewOpener);
        return CDOCompareEditorUtil.createComparisonInput(leftView, rightView, comparison);
    }

    public static Input createComparisonInput(CDOView leftView, CDOView rightView, Set<CDOID> affectedIDs) {
        CDOComparisonScope.Minimal scope = new CDOComparisonScope.Minimal(leftView, rightView, null, affectedIDs);
        Comparison comparison = CDOCompareUtil.compare((IComparisonScope)scope);
        return CDOCompareEditorUtil.createComparisonInput(leftView, rightView, comparison);
    }

    public static Input createComparisonInput(CDOView leftView, CDOView rightView, Comparison comparison) {
        String rightLabel;
        IRegistry rightProperties;
        Image rightImage;
        String leftLabel;
        if (comparison.getDifferences().isEmpty()) {
            return null;
        }
        IComparisonScope scope = CDOCompare.getScope((Comparison)comparison);
        ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)scope.getLeft(), (Notifier)scope.getRight(), (Notifier)scope.getOrigin());
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(registry);
        CDOBranchPoint leftBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)leftView);
        CDOBranchPoint rightBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)rightView);
        CDOItemProvider itemProvider = new CDOItemProvider(null){

            public boolean useFullPath(Object object) {
                if (object instanceof CDOBranchPoint) {
                    return true;
                }
                return super.useFullPath(object);
            }
        };
        IRegistry leftProperties = leftView.properties();
        Image leftImage = (Image)leftProperties.get((Object)PROP_COMPARISON_IMAGE);
        if (leftImage == null) {
            leftImage = itemProvider.getImage((Object)leftBranchPoint);
        }
        if ((leftLabel = (String)leftProperties.get((Object)PROP_COMPARISON_LABEL)) == null) {
            leftLabel = itemProvider.getText((Object)leftBranchPoint);
        }
        if ((rightImage = (Image)(rightProperties = rightView.properties()).get((Object)PROP_COMPARISON_IMAGE)) == null) {
            rightImage = itemProvider.getImage((Object)rightBranchPoint);
        }
        if ((rightLabel = (String)rightProperties.get((Object)PROP_COMPARISON_LABEL)) == null) {
            rightLabel = itemProvider.getText((Object)rightBranchPoint);
        }
        itemProvider.dispose();
        boolean leftEditable = !leftView.isReadOnly();
        boolean rightEditable = !rightView.isReadOnly();
        String title = COMPARISON_TITLE.get();
        if (title == null) {
            boolean merge;
            String repositoryName = ((InternalCDOView)leftView).getRepositoryName();
            boolean bl = merge = leftEditable || rightEditable;
            if (merge) {
                title = "Merge " + repositoryName + " from " + leftLabel + " into " + rightLabel;
                leftLabel = "From " + leftLabel;
                rightLabel = "Into " + rightLabel;
            } else {
                title = "Compare " + repositoryName + " between " + leftLabel + " and " + rightLabel;
            }
        }
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftImage(leftImage);
        configuration.setLeftLabel(leftLabel);
        configuration.setLeftEditable(leftEditable);
        configuration.setRightImage(rightImage);
        configuration.setRightLabel(rightLabel);
        configuration.setRightEditable(rightEditable);
        Input input = new Input(leftView, rightView, configuration, comparison, editingDomain, (AdapterFactory)adapterFactory);
        input.setTitle(title);
        CDOCompareEditorUtil.workaroundEMFCompareBug(leftView, leftLabel);
        CDOCompareEditorUtil.workaroundEMFCompareBug(rightView, rightLabel);
        return input;
    }

    private static void workaroundEMFCompareBug(CDOView view, String label) {
        try {
            Class c = CommonPlugin.loadClass((String)"org.eclipse.emf.compare.ide", (String)"org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter");
            Constructor constructor = c.getConstructor(String.class, Boolean.TYPE);
            Adapter adapter = (Adapter)constructor.newInstance(label, false);
            for (Resource resource : view.getResourceSet().getResources()) {
                resource.eAdapters().add((Object)adapter);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void runWithTitle(String title, Runnable runnable) {
        COMPARISON_TITLE.set(title);
        try {
            runnable.run();
        }
        finally {
            COMPARISON_TITLE.remove();
        }
    }

    public static void setInputConsumer(Consumer<Input> consumer) {
        if (consumer != null) {
            INPUT_CONSUMER.set(consumer);
        } else {
            INPUT_CONSUMER.remove();
        }
    }

    public static boolean isSuppressCommit() {
        return Boolean.TRUE.equals(SUPPRESS_COMMIT.get());
    }

    public static void setSuppressCommit(boolean suppressCommit) {
        if (suppressCommit) {
            SUPPRESS_COMMIT.set(true);
        } else {
            SUPPRESS_COMMIT.remove();
        }
    }

    public static void addDisposeRunnables(Runnable ... disposeRunnables) {
        List<Runnable> list = DISPOSE_RUNNABLES.get();
        if (list == null) {
            list = new ArrayList<Runnable>();
            DISPOSE_RUNNABLES.set(list);
        }
        list.addAll(Arrays.asList(disposeRunnables));
    }

    private static List<Runnable> removeDisposeRunnables() {
        List<Runnable> list = DISPOSE_RUNNABLES.get();
        DISPOSE_RUNNABLES.remove();
        return list;
    }

    private static void runDisposeRunnables(List<Runnable> disposeRunnables) {
        if (disposeRunnables != null) {
            for (Runnable disposeRunnable : disposeRunnables) {
                try {
                    disposeRunnable.run();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }

    private static boolean handleMerges(InternalCDOTransaction transaction, EList<Diff> differences) {
        Map cleanRevisions = transaction.getCleanRevisions();
        Map revisionDeltas = transaction.getLastSavepoint().getRevisionDeltas2();
        boolean unmergedConflicts = false;
        for (Diff diff : differences) {
            if (diff.getState() != DifferenceState.MERGED) {
                unmergedConflicts = true;
                continue;
            }
            Match match = diff.getMatch();
            EObject left = match.getLeft();
            EObject right = match.getRight();
            if (left == null || right == null) continue;
            InternalCDOObject leftObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)left);
            InternalCDOObject rightObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)right);
            InternalCDORevision leftRevision = leftObject.cdoRevision();
            cleanRevisions.put(rightObject, leftRevision);
            int remoteVersion = leftRevision.getVersion();
            InternalCDORevision rightRevision = rightObject.cdoRevision();
            rightRevision.setBranchPoint((CDOBranchPoint)leftRevision);
            rightRevision.setVersion(remoteVersion);
            InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)revisionDeltas.get(rightRevision.getID());
            if (revisionDelta != null) {
                revisionDelta.setVersion(remoteVersion);
            }
            transaction.removeConflict(rightObject);
            rightObject.cdoInternalSetState(CDOState.DIRTY);
        }
        return !unmergedConflicts;
    }

    public static final class Input
    extends ComparisonEditorInput {
        private final CDOView sourceView;
        private final CDOView targetView;
        private final Comparison comparison;
        private List<Runnable> disposeRunnables;
        private boolean suppressCommit;
        private CDOCommitInfo commitInfo;
        private boolean ok;

        private Input(CDOView sourceView, CDOView targetView, CompareConfiguration configuration, Comparison comparison, ICompareEditingDomain editingDomain, AdapterFactory adapterFactory) {
            super(Input.createEMFCompareConfiguration(configuration, adapterFactory), comparison, editingDomain, adapterFactory);
            this.sourceView = sourceView;
            this.targetView = targetView;
            this.comparison = comparison;
            this.suppressCommit = CDOCompareEditorUtil.isSuppressCommit();
            SUPPRESS_COMMIT.remove();
            Consumer<Input> consumer = INPUT_CONSUMER.get();
            INPUT_CONSUMER.remove();
            if (consumer != null) {
                consumer.accept(this);
            }
        }

        private static EMFCompareConfiguration createEMFCompareConfiguration(CompareConfiguration configuration, AdapterFactory adapterFactory) {
            EMFCompareConfiguration result = new EMFCompareConfiguration(configuration);
            result.setAdapterFactory(adapterFactory);
            return result;
        }

        private void dispose() {
            AdapterFactory adapterFactory = this.getAdapterFactory();
            if (adapterFactory instanceof ComposedAdapterFactory) {
                ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)adapterFactory;
                composedAdapterFactory.dispose();
            }
            CDOCompareEditorUtil.runDisposeRunnables(this.disposeRunnables);
            this.disposeRunnables = null;
        }

        public final Comparison getComparison() {
            return this.comparison;
        }

        public Image getTitleImage() {
            return CDOCompareEditorUtil.compareImage();
        }

        public void setDisposeRunnables(List<Runnable> disposeRunnables) {
            this.disposeRunnables = disposeRunnables;
        }

        public void saveChanges(IProgressMonitor monitor) throws CoreException {
            if (this.targetView instanceof InternalCDOTransaction) {
                Collection values;
                InternalCDOTransaction transaction = (InternalCDOTransaction)this.targetView;
                if (transaction.isDirty() && !(values = transaction.getNewObjects().values()).isEmpty()) {
                    CDOObject[] rightObjects;
                    Map idMappings = CDOIDUtil.createMap();
                    CDOObject[] cDOObjectArray = rightObjects = values.toArray(new CDOObject[values.size()]);
                    int n = rightObjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOObject leftObject;
                        EObject left;
                        CDOObject rightObject = cDOObjectArray[n2];
                        Match match = this.comparison.getMatch((EObject)rightObject);
                        if (match != null && (left = match.getLeft()) != null && (leftObject = CDOUtil.getCDOObject((EObject)left)) != null) {
                            CDOID id = leftObject.cdoID();
                            idMappings.put(rightObject.cdoID(), id);
                            CDOTransactionImpl.resurrectObject((CDOObject)rightObject, (CDOID)id);
                        }
                        ++n2;
                    }
                    if (!idMappings.isEmpty()) {
                        InternalCDORevision revision;
                        CDOIDMapper idMapper = new CDOIDMapper(idMappings);
                        for (CDOObject newObject : values) {
                            revision = (InternalCDORevision)newObject.cdoRevision();
                            revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                        }
                        for (CDOObject dirtyObject : transaction.getDirtyObjects().values()) {
                            revision = (InternalCDORevision)dirtyObject.cdoRevision();
                            revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                        }
                    }
                }
                try {
                    if (!this.suppressCommit) {
                        CDOBranchPoint mergeSource = this.sourceView.isHistorical() ? CDOBranchUtil.copyBranchPoint((CDOBranchPoint)this.sourceView) : this.sourceView.getBranch().getPoint(this.sourceView.getLastUpdateTime());
                        transaction.setCommitMergeSource(mergeSource);
                        this.commitInfo = transaction.commit(monitor);
                        this.setDirty(false);
                    }
                }
                catch (Exception ex) {
                    OM.BUNDLE.coreException((Throwable)ex);
                }
            }
        }

        public CDOCommitInfo getCommitInfo() {
            return this.commitInfo;
        }

        public boolean isOK() {
            return this.ok;
        }

        public boolean okPressed() {
            try {
                this.ok = true;
                boolean bl = super.okPressed();
                return bl;
            }
            finally {
                this.dispose();
            }
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            try {
                super.removePropertyChangeListener(listener);
            }
            finally {
                this.dispose();
            }
        }
    }

    public static class InputHolder
    implements Consumer<Input> {
        private Input input;

        public Input getInput() {
            return this.input;
        }

        @Override
        public void accept(Input input) {
            this.input = input;
        }
    }

    public static final class TransactionOpenerAndEditorCloser
    implements CDOTransactionOpener {
        private final CDOTransactionOpener delegate;
        private final boolean closeTransactionAfterCommit;

        public TransactionOpenerAndEditorCloser(CDOTransactionOpener delegate, boolean closeTransactionAfterCommit) {
            this.delegate = delegate;
            this.closeTransactionAfterCommit = closeTransactionAfterCommit;
        }

        public boolean isCloseTransactionAfterCommit() {
            return this.closeTransactionAfterCommit;
        }

        public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
            return this.wrap(this.delegate.openTransaction(durableLockingID, resourceSet));
        }

        public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
            return this.wrap(this.delegate.openTransaction(target, resourceSet));
        }

        private CDOTransaction wrap(CDOTransaction transaction) {
            if (this.closeTransactionAfterCommit) {
                CDOCompareEditorUtil.closeTransactionAfterCommit(transaction);
            }
            CDOCompareEditorUtil.closeEditorWithTransaction(transaction);
            return transaction;
        }
    }
}

