/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContextType;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class QObjectDeclarationCompletion {
    private static final String TEMPLATE = "class ${name} : public ${QObject}\n{\nQ_OBJECT\n\n${cursor}\n};";
    private static final TranslationUnitContextType context = new CContextType();

    static {
        context.setId("org.eclipse.cdt.ui.text.templates.c");
    }

    public static Collection<ICompletionProposal> getProposals(ICEditorContentAssistInvocationContext ctx, IASTName name) {
        String token = name.getLastName().toString();
        if (token.isEmpty() || !"class".startsWith(token)) {
            return null;
        }
        Position position = QObjectDeclarationCompletion.getPosition(ctx);
        if (position == null) {
            return null;
        }
        TranslationUnitContext tuCtx = context.createContext(ctx.getDocument(), position, ctx.getTranslationUnit());
        Region region = new Region(position.getOffset(), position.getLength());
        Template template = new Template("class", "QObject declaration", "org.eclipse.cdt.ui.text.templates.c", TEMPLATE, true);
        return Collections.singletonList(new TemplateEngine.CTemplateProposal(template, (TemplateContext)tuCtx, (IRegion)region, Activator.getQtLogo()));
    }

    private static Position getPosition(ICEditorContentAssistInvocationContext context) {
        ITextEditor textEditor = (ITextEditor)context.getEditor().getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return null;
        }
        ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        ITextSelection text = (ITextSelection)selection;
        return new Position(text.getOffset(), text.getLength());
    }
}

