/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath.rules;

import org.eclipse.bpel.ui.editors.xpath.XPathWhitespaceDetector;
import org.eclipse.bpel.ui.editors.xpath.rules.WordRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class FunctionRule
extends WordRule {
    static final XPathWhitespaceDetector fWhiteSpaceDetector = new XPathWhitespaceDetector();

    public FunctionRule(IWordDetector detector) {
        super(detector);
    }

    public void addWords(String[] words, IToken token) {
        int i = 0;
        while (i < words.length) {
            this.addWord(words[i], token);
            ++i;
        }
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner) {
        int ch;
        IToken token = super.evaluate(scanner);
        if (token == Token.UNDEFINED) {
            return token;
        }
        int cnt = 0;
        do {
            ch = scanner.read();
            ++cnt;
        } while (fWhiteSpaceDetector.isWhitespace((char)ch));
        if (ch == 40) {
            while (cnt > 0) {
                scanner.unread();
                --cnt;
            }
            return token;
        }
        this.unreadBuffer(scanner);
        return Token.UNDEFINED;
    }
}

