/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.preview;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jst.pagedesigner.preview.IELValueResolver;
import org.eclipse.jst.pagedesigner.preview.PageExpressionContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultELValueResolver
implements IELValueResolver {
    @Override
    public String resolve(Element element, String elExpression) {
        String ret = elExpression;
        if (elExpression != null) {
            List<VariablePropertyPair> possibleVars = this.getPossiblePageVariables(elExpression);
            for (VariablePropertyPair pageVar : possibleVars) {
                String resolvedValue;
                Object objPageVar = PageExpressionContext.getCurrent().getPageVariable(pageVar.getVariableName());
                if (!(objPageVar instanceof Properties) || (resolvedValue = ((Properties)objPageVar).getProperty(pageVar.getPropertyName())) == null) continue;
                ret = resolvedValue;
                break;
            }
        }
        return ret;
    }

    private List<VariablePropertyPair> getPossiblePageVariables(String elExpression) {
        ArrayList<VariablePropertyPair> possibleVars = new ArrayList<VariablePropertyPair>();
        if (elExpression != null && (elExpression.startsWith("#{") || elExpression.startsWith("${")) && elExpression.endsWith("}")) {
            String exp = elExpression.substring(2, elExpression.length() - 1);
            int dotPos = exp.indexOf(46);
            while (dotPos > -1 && dotPos < exp.length() - 1) {
                String var = exp.substring(0, dotPos);
                String prop = exp.substring(dotPos + 1);
                possibleVars.add(new VariablePropertyPair(var, prop));
                dotPos = exp.indexOf(46, dotPos + 1);
            }
        }
        return possibleVars;
    }

    class VariablePropertyPair {
        private String variableName;
        private String propertyName;

        public VariablePropertyPair(String variableName, String propertyName) {
            this.variableName = variableName;
            this.propertyName = propertyName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return "VariablePropertyPair[" + this.variableName + ", " + this.propertyName + "]";
        }
    }
}

