/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.dataStructures;

import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;

public class DisplayIndependentPoint {
    public double x;
    public double y;

    public boolean equals(Object o) {
        DisplayIndependentPoint that = (DisplayIndependentPoint)o;
        return this.x == that.x && this.y == that.y;
    }

    public DisplayIndependentPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public DisplayIndependentPoint(DisplayIndependentPoint point) {
        this.x = point.x;
        this.y = point.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public DisplayIndependentPoint convert(DisplayIndependentRectangle currentBounds, DisplayIndependentRectangle targetBounds) {
        double currentWidth = currentBounds.width;
        double currentHeight = currentBounds.height;
        double newX = currentBounds.width == 0.0 ? 0.0 : this.x / currentWidth * targetBounds.width + targetBounds.x;
        double newY = currentBounds.height == 0.0 ? 0.0 : this.y / currentHeight * targetBounds.height + targetBounds.y;
        return new DisplayIndependentPoint(newX, newY);
    }

    public DisplayIndependentPoint convertToPercent(DisplayIndependentRectangle bounds) {
        double newX = bounds.width == 0.0 ? 0.0 : (this.x - bounds.x) / bounds.width;
        double newY = bounds.height == 0.0 ? 0.0 : (this.y - bounds.y) / bounds.height;
        return new DisplayIndependentPoint(newX, newY);
    }

    public DisplayIndependentPoint convertFromPercent(DisplayIndependentRectangle bounds) {
        double newX = bounds.x + this.x * bounds.width;
        double newY = bounds.y + this.y * bounds.height;
        return new DisplayIndependentPoint(newX, newY);
    }
}

