/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.linecharts;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class StepChart
extends ScrollableChart {
    private static final int DISPLAY_WIDTH;
    public static final String COMPRESSION_EXTREME = "Extreme";
    public static final String COMPRESSION_HIGH = "High";
    public static final String COMPRESSION_MEDIUM = "Medium";
    public static final String COMPRESSION_LOW = "Low";
    public static final String COMPRESSION_NONE = "None";
    public static final String COMPRESSION_AUTO = "Auto";
    public static final int EXTREME_COMPRESSION;
    public static final int HIGH_COMPRESSION;
    public static final int MEDIUM_COMPRESSION;
    public static final int LOW_COMPRESSION;
    public static final int NO_COMPRESSION = Integer.MAX_VALUE;

    static {
        EXTREME_COMPRESSION = DISPLAY_WIDTH = Display.getDefault().getClientArea().width;
        HIGH_COMPRESSION = DISPLAY_WIDTH * 2;
        MEDIUM_COMPRESSION = DISPLAY_WIDTH * 5;
        LOW_COMPRESSION = DISPLAY_WIDTH * 10;
    }

    public StepChart() {
    }

    public StepChart(Composite parent, int style) {
        super(parent, style);
    }

    public void addSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        this.addSeriesData(lineSeriesDataList, Integer.MAX_VALUE);
    }

    public void addSeriesData(List<ILineSeriesData> lineSeriesDataList, int compressToLength) {
        if (lineSeriesDataList != null && lineSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (ILineSeriesData lineSeriesData : lineSeriesDataList) {
                try {
                    ISeriesData seriesData = lineSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, compressToLength);
                    ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                    lineSeriesSettings.getSeriesSettingsHighlight();
                    lineSeriesSettings.setEnableStep(true);
                    ILineSeries lineSeries = (ILineSeries)this.createSeries(optimizedSeriesData, lineSeriesSettings);
                    baseChart.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

