/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.ResourceSupport;

public class SeriesLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final String ID = "ID";
    public static final String VISIBLE = "Visible";
    public static final String VISIBLE_IN_LEGEND = "Visible In Legend";
    public static final String COLOR = "Color";
    public static final String DESCRIPTION = "Description";
    public static final int INDEX_ID = 0;
    public static final int INDEX_VISIBLE = 1;
    public static final int INDEX_VISIBLE_IN_LEGEND = 2;
    public static final String[] TITLES = new String[]{"ID", "Visible", "Visible In Legend", "Color", "Description"};
    public static final int[] BOUNDS = new int[]{24, 30, 30, 30, 200};

    public static boolean isVisible(Object element) {
        boolean isVisible = false;
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            isVisible = series.isVisible();
        }
        return isVisible;
    }

    public static boolean isVisibleInLegend(Object element) {
        boolean isVisible = false;
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            isVisible = series.isVisibleInLegend();
        }
        return isVisible;
    }

    public static Color getColor(Object element) {
        Color color = null;
        if (element instanceof IBarSeries) {
            IBarSeries series = (IBarSeries)element;
            color = series.getBarColor();
        } else if (element instanceof ILineSeries) {
            ILineSeries series = (ILineSeries)element;
            color = series.getLineColor();
        }
        return color;
    }

    public static void setColor(Object element, Color color) {
        if (color != null) {
            if (element instanceof IBarSeries) {
                IBarSeries barSeries = (IBarSeries)element;
                barSeries.setBarColor(color);
            } else if (element instanceof ILineSeries) {
                ILineSeries lineSeries = (ILineSeries)element;
                lineSeries.setLineColor(color);
            }
        }
    }

    public static String getDescription(Object element) {
        String description = "";
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            description = series.getDescription();
        }
        return description;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISeries) {
            Image seriesMarker = ResourceSupport.getImage("seriesMarker.gif");
            Image checked = ResourceSupport.getImage("checked.gif");
            Image unchecked = ResourceSupport.getImage("unchecked.gif");
            if (columnIndex == 0) {
                return seriesMarker;
            }
            if (columnIndex == 1) {
                return SeriesLabelProvider.isVisible(element) ? checked : unchecked;
            }
            if (columnIndex == 2) {
                return SeriesLabelProvider.isVisibleInLegend(element) ? checked : unchecked;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            switch (columnIndex) {
                case 0: {
                    text = series.getId();
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = "";
                    break;
                }
                case 3: {
                    text = "";
                    break;
                }
                case 4: {
                    text = series.getDescription();
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }
}

