/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.natures;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class ApiToolProjectNature
implements IProjectNature {
    IProject project;

    public void configure() throws CoreException {
        this.addToBuildSpec("org.eclipse.pde.api.tools.apiAnalysisBuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.pde.api.tools.apiAnalysisBuilder");
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        ICommand[] newCommands;
        IProjectDescription description = this.project.getDescription();
        ICommand[] oldBuildSpec = description.getBuildSpec();
        int oldApiCommandIndex = -1;
        int length = oldBuildSpec.length;
        int i = 0;
        while (i < length) {
            if (oldBuildSpec[i].getBuilderName().equals(builderID)) {
                oldApiCommandIndex = i;
                break;
            }
            ++i;
        }
        ICommand newCommand = description.newCommand();
        newCommand.setBuilderName(builderID);
        if (oldApiCommandIndex == -1) {
            newCommands = new ICommand[length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 0, length);
            newCommands[length] = newCommand;
        } else {
            oldBuildSpec[oldApiCommandIndex] = newCommand;
            newCommands = oldBuildSpec;
        }
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, null);
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }
}

