/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.internal.Activator;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogInternal;
import org.eclipse.modisco.facet.efacet.ui.internal.widget.FacetSetSelectionControl;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetSetSelectionDialog<T>
extends SelectionStatusDialog
implements IFacetSetSelectionDialogInternal<T> {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private final Collection<FacetSet> available;
    private final int selectionMaxSize;
    private final boolean allowEmpty;
    private final IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, T> callback;
    private FacetSetSelectionControl selectionControl;

    public FacetSetSelectionDialog(Collection<FacetSet> available, int selectionMaxSize, boolean allowEmpty, IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, T> callback, Shell parentShell) {
        super(parentShell);
        Assert.isLegal((callback != null ? 1 : 0) != 0, (String)"available cannot be null");
        Assert.isLegal((callback != null ? 1 : 0) != 0, (String)"callback cannot be null");
        Assert.isLegal((selectionMaxSize > 0 ? 1 : 0) != 0, (String)"selectionMaxSize must be > 0");
        this.available = available;
        this.selectionMaxSize = selectionMaxSize;
        this.allowEmpty = allowEmpty;
        this.callback = callback;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Runnable onChange = new Runnable(){

            public void run() {
                FacetSetSelectionDialog.this.updateValidationStatus();
            }
        };
        this.selectionControl = this.createFacetSetSelectionControl(composite, onChange);
        this.selectionControl.createContents();
        this.selectionControl.setAvailableFacetSets(this.available);
        this.updateValidationStatus();
        return composite;
    }

    protected FacetSetSelectionControl createFacetSetSelectionControl(Composite parentComposite, Runnable onChange) {
        return new FacetSetSelectionControl(parentComposite, this.selectionMaxSize, this.allowEmpty, onChange);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 18, Messages.FacetSetSelectionDialog_selectAll, false);
        this.createButton(parent, 19, Messages.FacetSetSelectionDialog_deselectAll, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (18 == buttonId) {
            this.selectAll();
        } else if (19 == buttonId) {
            this.deselectAll();
        }
    }

    protected void updateValidationStatus() {
        this.updateStatus(this.selectionControl.getValidationStatus());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.selectionMaxSize > 1) {
            shell.setText(Messages.FacetSetSelectionDialog_titleSelectFacetSets);
        } else {
            shell.setText(Messages.FacetSetSelectionDialog_titleSelectFacetSet);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(this.getClass().getName()) + ".settings";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
            section.put("DIALOG_WIDTH", 800);
            section.put("DIALOG_HEIGHT", 600);
        }
        return section;
    }

    public boolean isErrorStatus() {
        IStatus validationStatus = this.selectionControl.getValidationStatus();
        return validationStatus == null || validationStatus.getSeverity() >= 4;
    }

    @Override
    public T pressOk() {
        IDialogCallback<Boolean> precommitCallBack = new IDialogCallback<Boolean>(){

            public void committed(Boolean precommitResult) {
                FacetSetSelectionDialog.this.commit(precommitResult);
            }
        };
        Object dialog = this.callback.openPrecommitDialog(this.getSelectedFacetSets(), (IDialogCallback)precommitCallBack);
        if (dialog == null) {
            this.commit(Boolean.TRUE);
        }
        return (T)dialog;
    }

    @Override
    public void pressCancel() {
        this.setReturnCode(1);
        this.close();
    }

    protected void okPressed() {
        this.pressOk();
    }

    protected void cancelPressed() {
        this.pressCancel();
    }

    protected void commit(final Boolean precommitResult) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                FacetSetSelectionDialog.this.commitOnUIThread(precommitResult);
            }
        });
    }

    protected void commitOnUIThread(Boolean precommitResult) {
        List<FacetSet> selectedFacetSets = this.getSelectedFacetSets();
        this.setReturnCode(0);
        this.close();
        this.callback.committed(selectedFacetSets, (Object)precommitResult);
    }

    public int open() {
        this.setBlockOnOpen(false);
        return super.open();
    }

    public List<FacetSet> getSelectedFacetSets() {
        if (this.selectionControl.isDisposed()) {
            throw new UnsupportedOperationException("No selection available because the dialog is closed");
        }
        return this.selectionControl.getSelectedFacetSets();
    }

    @Override
    public void setSelectedFacetSets(List<? extends FacetSet> newSelection) {
        this.selectionControl.setSelectedFacetSets(newSelection);
        this.updateValidationStatus();
    }

    @Override
    public void selectAll() {
        this.selectionControl.selectAll();
        this.updateValidationStatus();
    }

    @Override
    public void deselectAll() {
        this.selectionControl.deselectAll();
        this.updateValidationStatus();
    }

    @Override
    public boolean isOkButtonEnabled() {
        return this.getOkButton().isEnabled();
    }

    protected void computeResult() {
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.selectionControl.getTreeViewer();
    }
}

