/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.resources;

import java.util.ArrayList;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.resources.QMLTernFileUpdateJob;
import org.eclipse.cdt.internal.qt.ui.resources.QtProjectFileUpdateJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class QtResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getType() & 0x11) == 0) {
            return;
        }
        final ArrayList<IResourceDelta> deltaList = new ArrayList<IResourceDelta>();
        final ArrayList<IResourceDelta> qmlDeltaList = new ArrayList<IResourceDelta>();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResource resource = delta.getResource();
                if (resource.getType() == 8) {
                    return true;
                }
                if (resource.getType() == 4) {
                    try {
                        IProject project = (IProject)resource;
                        if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.cdt.qt.core.qtNature")) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                    return false;
                }
                if (resource.getType() == 2) {
                    if (resource.getType() == 2 && resource.getName().equals("build")) {
                        return false;
                    }
                    try {
                        IProject project = resource.getProject();
                        if (project != null && project.hasNature("org.eclipse.cdt.qt.core.qtNature")) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                    return false;
                }
                if ((delta.getKind() & 4) > 0) {
                    return false;
                }
                if ((delta.getKind() & 1 | 2) == 0) {
                    return false;
                }
                if ("cpp".equals(resource.getFileExtension()) || "h".equals(resource.getFileExtension())) {
                    deltaList.add(delta);
                } else if ("qml".equals(resource.getFileExtension())) {
                    qmlDeltaList.add(delta);
                }
                return false;
            }
        };
        try {
            event.getDelta().accept(visitor);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        if (!deltaList.isEmpty()) {
            new QtProjectFileUpdateJob(deltaList).schedule();
        }
        if (!qmlDeltaList.isEmpty()) {
            new QMLTernFileUpdateJob(qmlDeltaList).schedule();
        }
    }
}

