/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.NonclippingXYLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;

public class FlowXYLayout
extends NonclippingXYLayout {
    EditPart flowEditPart;

    public FlowXYLayout(EditPart flowEditPart) {
        this.flowEditPart = flowEditPart;
    }

    public Object getConstraint(IFigure figure) {
        RootEditPart rootEditPart;
        Object constraint = super.getConstraint(figure);
        if (constraint != null) {
            return constraint;
        }
        EditPart editPart = BPELUtil.mapFigure2EditPart(this.flowEditPart.getViewer(), figure);
        if (editPart != null && editPart.getModel() instanceof Activity && (rootEditPart = editPart.getRoot()) instanceof GraphicalBPELRootEditPart) {
            Point p = ModelHelper.getLocation((Activity)editPart.getModel());
            if (p.x == Integer.MIN_VALUE) {
                p = new Point(0, 0);
            }
            Dimension s = new Dimension(-1, -1);
            Rectangle r = new Rectangle(p, s);
            ((GraphicalEditPart)this.flowEditPart).setLayoutConstraint(editPart, figure, (Object)r);
            return r;
        }
        return super.getConstraint(figure);
    }
}

