/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Target;
import org.eclipse.emf.ecore.EObject;

public class FlowLinkUtil {
    public static Flow getCommonFlow(Activity source, Activity target) {
        if (source == null || target == null) {
            return null;
        }
        Flow[] sourceParents = FlowLinkUtil.getParentFlows((EObject)source);
        Flow[] targetParents = FlowLinkUtil.getParentFlows((EObject)target);
        if (sourceParents == null || targetParents == null) {
            return null;
        }
        int sIdx = sourceParents.length - 1;
        int tIdx = targetParents.length - 1;
        Flow commonFlow = null;
        while (sIdx >= 0 && tIdx >= 0) {
            if (sourceParents[sIdx] != targetParents[tIdx]) break;
            commonFlow = sourceParents[sIdx];
            --sIdx;
            --tIdx;
        }
        return commonFlow;
    }

    public static boolean hasParentFlow(EObject object) {
        object = object.eContainer();
        while (object != null) {
            if (object instanceof Flow) {
                return true;
            }
            object = object.eContainer();
        }
        return false;
    }

    public static Flow[] getParentFlows(EObject object) {
        ArrayList list = new ArrayList();
        FlowLinkUtil.getParentFlows(object.eContainer(), list);
        return list.toArray(new Flow[list.size()]);
    }

    protected static void getParentFlows(EObject object, List list) {
        if (object == null) {
            return;
        }
        if (object instanceof Process) {
            return;
        }
        if (object instanceof Flow) {
            list.add(object);
        }
        FlowLinkUtil.getParentFlows(object.eContainer(), list);
    }

    public static List getFlowLinks(Flow flow) {
        if (flow.getLinks() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(flow.getLinks().getChildren());
    }

    public static void addFlowLink(Flow flow, Link link) {
        if (flow.getLinks() == null) {
            flow.setLinks(BPELFactory.eINSTANCE.createLinks());
        }
        flow.getLinks().getChildren().add((Object)link);
    }

    public static void removeFlowLink(Flow flow, Link link) {
        if (flow.getLinks() != null) {
            flow.getLinks().getChildren().remove((Object)link);
            if (flow.getLinks().getChildren().isEmpty()) {
                flow.setLinks(null);
            }
        }
    }

    public static void removeActivitySource(Source source) {
        Activity activity = source.getActivity();
        if (activity != null && activity.getSources() != null) {
            activity.getSources().getChildren().remove((Object)source);
            if (activity.getSources().getChildren().isEmpty()) {
                activity.setSources(null);
            }
        }
    }

    public static void removeActivityTarget(Target target) {
        Activity activity = target.getActivity();
        if (activity != null && activity.getTargets() != null) {
            activity.getTargets().getChildren().remove((Object)target);
            if (activity.getTargets().getChildren().isEmpty()) {
                activity.setTargets(null);
            }
        }
    }

    public static Activity getLinkSource(Link link) {
        if (link.getSources().isEmpty()) {
            return null;
        }
        return ((Source)link.getSources().get(0)).getActivity();
    }

    public static Activity getLinkTarget(Link link) {
        if (link.getTargets().isEmpty()) {
            return null;
        }
        return ((Target)link.getTargets().get(0)).getActivity();
    }

    public static void setLinkSource(Link link, Activity activity) {
        if (link.getSources().isEmpty()) {
            if (activity != null) {
                Source source = BPELFactory.eINSTANCE.createSource();
                link.getSources().add((Object)source);
                source.setActivity(activity);
            }
        } else {
            Source source = (Source)link.getSources().get(0);
            Activity oldActivity = source.getActivity();
            if (activity != null) {
                source.setActivity(activity);
            } else {
                link.getSources().remove((Object)source);
            }
            if (oldActivity != null && oldActivity.getSources() != null && oldActivity.getSources().getChildren().isEmpty()) {
                oldActivity.setSources(null);
            }
        }
    }

    public static void setLinkTarget(Link link, Activity activity) {
        if (link.getTargets().isEmpty()) {
            if (activity != null) {
                Target target = BPELFactory.eINSTANCE.createTarget();
                link.getTargets().add((Object)target);
                target.setActivity(activity);
            }
        } else {
            Target target = (Target)link.getTargets().get(0);
            Activity oldActivity = target.getActivity();
            if (activity != null) {
                target.setActivity(activity);
            } else {
                link.getTargets().remove((Object)target);
            }
            if (oldActivity != null && oldActivity.getTargets() != null && oldActivity.getTargets().getChildren().isEmpty()) {
                oldActivity.setTargets(null);
            }
        }
    }

    public static void replaceLinkSourceAndTarget(Activity from, Activity to) {
        Flow[] flows = FlowLinkUtil.getParentFlows((EObject)from);
        if (flows != null && flows.length > 0) {
            Flow flow = flows[0];
            List links = FlowLinkUtil.getFlowLinks(flow);
            for (Link link : links) {
                Activity temp = FlowLinkUtil.getLinkSource(link);
                if (temp != null && temp == from) {
                    FlowLinkUtil.setLinkSource(link, to);
                    continue;
                }
                temp = FlowLinkUtil.getLinkTarget(link);
                if (temp == null || temp != from) continue;
                FlowLinkUtil.setLinkTarget(link, to);
            }
        }
    }
}

