/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.InsertInContainerCommand;
import org.eclipse.bpel.ui.commands.SetNameCommand;
import org.eclipse.bpel.ui.commands.SetVariableTypeCommand;
import org.eclipse.bpel.ui.dialogs.SelectionAndCreationDialog;
import org.eclipse.bpel.ui.properties.PropertiesLabelProvider;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableSelectorDialog
extends SelectionAndCreationDialog {
    protected EObject modelObject;
    protected Map nameToVariable;
    protected Variable[] variables;
    protected EObject variableType;
    protected Text filterText;

    public VariableSelectorDialog(Shell parent, EObject modelObject, EObject variableType) {
        super(parent, (ILabelProvider)new PropertiesLabelProvider(), (ILabelProvider)new TypeLabelProvider());
        this.modelObject = modelObject;
        this.variableType = variableType;
        this.nameToVariable = new HashMap();
        this.setMessage(Messages.VariableSelectorDialog_Variable_Name_wildcards_1);
        this.setUpperListLabel(Messages.VariableSelectorDialog_Matches_2);
        this.setLowerListLabel(Messages.VariableSelectorDialog_Variable_Type_4);
        this.refreshVariables();
    }

    protected void refreshVariables() {
        this.variables = BPELUtil.getVisibleVariables(this.modelObject);
        this.setElements(this.variables);
        if (this.fFilteredList != null) {
            this.setListElements(this.variables);
        }
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList result = super.createFilteredList(parent);
        result.setComparator((Comparator)new VariableComparator());
        return result;
    }

    @Override
    protected void handleNewButtonPushed() {
        Variable variable = BPELFactory.eINSTANCE.createVariable();
        Process process = BPELUtils.getProcess((Object)this.modelObject);
        String newName = this.filterText.getText();
        newName = BPELUtil.generateUniqueModelName((EObject)process, newName, (EObject)variable);
        NameDialog nameDialog = new NameDialog(this.getShell(), Messages.VariableSelectorDialog_New_Variable_4, Messages.VariableSelectorDialog_Variable_Name_5, newName, BPELUtil.getNCNameValidator());
        if (nameDialog.open() == 0) {
            String newVariableName = nameDialog.getValue();
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new InsertInContainerCommand((EObject)process, (EObject)variable, null));
            command.add((Command)new SetNameCommand((EObject)variable, newVariableName));
            command.add((Command)new SetVariableTypeCommand(variable, this.variableType));
            ModelHelper.getBPELEditor(process).getCommandStack().execute((Command)command);
            this.refreshVariables();
            this.setFilter(variable.getName());
            this.setLowerSelectedElement(variable);
            this.getOkButton().setFocus();
        }
    }

    protected Variable getVariable(String name) {
        Variable result = (Variable)this.nameToVariable.get(name);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < this.variables.length) {
            if (name.equals(this.variables[i].getName())) {
                this.nameToVariable.put(name, this.variables[i]);
                return this.variables[i];
            }
            ++i;
        }
        return null;
    }

    public Variable getVariable() {
        if (this.getResult().length > 0) {
            return (Variable)this.getResult()[0];
        }
        return null;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        this.filterText = super.createFilterText(parent);
        return this.filterText;
    }

    protected static class TypeLabelProvider
    extends LabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Variable) {
                Variable variable = (Variable)element;
                if (variable.getMessageType() != null) {
                    Message message = variable.getMessageType();
                    QName qname = message.getQName();
                    String uri = NamespaceUtils.convertUriToNamespace(qname.getNamespaceURI());
                    return String.valueOf(uri) + " - " + qname.getLocalPart();
                }
                if (variable.getType() != null) {
                    return XSDUtils.getDisplayNameFromXSDType(variable.getType());
                }
                if (variable.getXSDElement() != null) {
                    return variable.getXSDElement().getName();
                }
            }
            return Messages.VariableSelectorDialog_None_0;
        }
    }

    protected class VariableComparator
    implements Comparator {
        protected VariableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = (String)o1;
            String name2 = (String)o2;
            if (name1 == null || name2 == null) {
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                return -1;
            }
            Variable var1 = VariableSelectorDialog.this.getVariable(name1);
            Variable var2 = VariableSelectorDialog.this.getVariable(name2);
            if (VariableSelectorDialog.this.variableType != null) {
                Message type1 = null;
                Message type2 = null;
                if (VariableSelectorDialog.this.variableType instanceof Message) {
                    type1 = var1.getMessageType();
                    type2 = var2.getMessageType();
                } else if (VariableSelectorDialog.this.variableType instanceof XSDTypeDefinition) {
                    type1 = var1.getType();
                    type2 = var2.getType();
                } else if (VariableSelectorDialog.this.variableType instanceof XSDElementDeclaration) {
                    type1 = var1.getXSDElement();
                    type2 = var2.getXSDElement();
                }
                if (VariableSelectorDialog.this.variableType.equals(type1) && !VariableSelectorDialog.this.variableType.equals(type2)) {
                    return -1;
                }
                if (!VariableSelectorDialog.this.variableType.equals(type1) && VariableSelectorDialog.this.variableType.equals(type2)) {
                    return 1;
                }
            }
            return name1.compareTo(name2);
        }
    }
}

