/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AutoUndoCommand
extends AbstractEditModelCommand {
    private Set<Object> fModelRoots;

    public AutoUndoCommand(String label, EObject modelRoot) {
        super(label);
        if (modelRoot == null) {
            throw new IllegalStateException("modelRoot cannot be null here");
        }
        this.fModelRoots = Collections.singleton(modelRoot);
    }

    public AutoUndoCommand(EObject modelRoot) {
        if (modelRoot == null) {
            throw new IllegalStateException("modelRoot cannot be null here");
        }
        this.fModelRoots = Collections.singleton(modelRoot);
    }

    public AutoUndoCommand(String label, ArrayList<Object> modelRoots) {
        super(label);
        this.fModelRoots = new HashSet<Object>();
        this.fModelRoots.addAll(modelRoots);
    }

    public AutoUndoCommand(ArrayList<Object> modelRoots) {
        this.fModelRoots = new HashSet<Object>();
        this.fModelRoots.addAll(modelRoots);
    }

    private void beginRecording(Object element) {
        if (element instanceof IDOMNode) {
            IDOMModel model = ((IDOMNode)element).getModel();
            model.aboutToChangeModel();
            model.beginRecording((Object)this, this.getUndoDescription());
        }
    }

    private void endRecording(Object element) {
        if (element instanceof IDOMNode) {
            IDOMModel model = ((IDOMNode)element).getModel();
            model.changedModel();
            model.endRecording((Object)this);
        }
    }

    protected String getUndoDescription() {
        return this.getLabel();
    }

    protected void formatChild(Element child) {
        if (child instanceof IDOMNode) {
            IDOMModel model = ((IDOMNode)child).getModel();
            try {
                model.aboutToChangeModel();
                FormatProcessorXML formatProcessor = new FormatProcessorXML();
                formatProcessor.formatNode((Node)child);
            }
            finally {
                model.changedModel();
            }
        }
    }

    public void execute() {
        if (this.canDoExecute()) {
            Object element = this.calculateLeastCommonAncestor();
            try {
                this.beginRecording(element);
                this.doExecute();
            }
            finally {
                this.endRecording(element);
            }
        }
    }

    private Object calculateLeastCommonAncestor() {
        Object[] roots = this.getModelRoots().toArray();
        if (roots.length == 0) {
            return null;
        }
        if (roots.length == 1) {
            return ((WSDLElement)roots[0]).getElement();
        }
        Integer worms = roots.length;
        HashMap<Object, Integer> wormed = new HashMap<Object, Integer>();
        HashSet old = new HashSet();
        HashSet<WSDLElement> current = new HashSet<WSDLElement>();
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            wormed.put(node, 1);
            current.add((WSDLElement)node);
            ++n2;
        }
        do {
            HashSet temp = old;
            old = current;
            current = temp;
            current.clear();
            for (WSDLElement node : old) {
                if (node.getContainer() == null) {
                    if (!(node instanceof Process)) continue;
                    return node.getElement();
                }
                Integer count = (Integer)wormed.get(node);
                if (count == null) {
                    wormed.put(node, 1);
                } else {
                    if (worms.equals(count + 1)) {
                        return node.getElement();
                    }
                    if (count != null) {
                        wormed.put(node, count + 1);
                    }
                }
                current.add(node.getContainer());
            }
        } while (!current.isEmpty());
        return ((BPELResource)((WSDLElement)roots[0]).eResource()).getProcess().getElement();
    }

    public boolean canDoExecute() {
        return true;
    }

    public void doExecute() {
    }

    protected void addModelRoot(Object modelRoot) {
        if (modelRoot == null) {
            throw new IllegalStateException("modelRoot cannot be null here");
        }
        this.getModelRoots().add(modelRoot);
    }

    protected void addModelRoots(List<Object> modelRoot) {
        this.getModelRoots().addAll(modelRoot);
    }

    protected void addModelRoots(Set<Object> modelRoot) {
        this.getModelRoots().addAll(modelRoot);
    }

    public Set<Object> getModelRoots() {
        return this.fModelRoots;
    }

    protected Resource getResource(Object modelRoot) {
        if (modelRoot instanceof EObject) {
            return ((EObject)modelRoot).eResource();
        }
        if (modelRoot instanceof Resource) {
            return (Resource)modelRoot;
        }
        throw new IllegalArgumentException();
    }

    public Resource[] getResources() {
        if (this.getModelRoots().size() < 2) {
            if (this.getModelRoots().isEmpty()) {
                throw new IllegalStateException();
            }
            Resource resource = this.getResource(this.getModelRoots().toArray()[0]);
            if (resource != null) {
                return new Resource[]{resource};
            }
            return EMPTY_RESOURCE_ARRAY;
        }
        HashSet<Resource> resultSet = new HashSet<Resource>(this.getModelRoots().size());
        for (Object next : this.getModelRoots()) {
            Resource resource = this.getResource(next);
            if (resource == null) continue;
            resultSet.add(resource);
        }
        return resultSet.toArray(EMPTY_RESOURCE_ARRAY);
    }

    public final Resource[] getModifiedResources() {
        return this.getResources();
    }
}

