/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.util.Map;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;

class LinkNotificationAdapter
extends MultiObjectAdapter {
    private BPELEditor bpelEditor;
    protected boolean DEBUG = false;

    LinkNotificationAdapter(BPELEditor editor) {
        this.bpelEditor = editor;
    }

    @Override
    public void notify(Notification n) {
        if (this.bpelEditor.getGraphicalViewer() == null) {
            return;
        }
        if (n.getNotifier() instanceof Links && n.getFeatureID(Links.class) == 4 && this.DEBUG) {
            System.out.println("Links change not handled yet!");
        }
        if (n.getNotifier() instanceof Sources && n.getFeatureID(Sources.class) == 4 && this.DEBUG) {
            System.out.println("Sources change not handled yet!");
        }
        if (n.getNotifier() instanceof Targets && n.getFeatureID(Targets.class) == 4 && this.DEBUG) {
            System.out.println("Targets change not handled yet!");
        }
        if (n.getNotifier() instanceof Source && n.getFeatureID(Source.class) == 5) {
            if (n.getOldValue() instanceof Activity) {
                this.refreshConnections((Activity)n.getOldValue(), "old source", true, false);
            }
            if (n.getNewValue() instanceof Activity) {
                this.refreshConnections((Activity)n.getNewValue(), "new source", true, false);
            }
        }
        if (n.getNotifier() instanceof Target && n.getFeatureID(Target.class) == 5) {
            if (n.getOldValue() instanceof Activity) {
                this.refreshConnections((Activity)n.getOldValue(), "old target", false, true);
            }
            if (n.getNewValue() instanceof Activity) {
                this.refreshConnections((Activity)n.getNewValue(), "new target", false, true);
            }
        }
        if (n.getNotifier() instanceof Activity) {
            if (n.getFeatureID(Activity.class) == 7) {
                switch (n.getEventType()) {
                    case 4: 
                    case 6: {
                        this.refreshConnections((Activity)n.getNotifier(), "old source(2)", true, false);
                        break;
                    }
                    case 3: 
                    case 5: {
                        this.refreshConnections((Activity)n.getNotifier(), "new source(2)", true, false);
                    }
                }
            }
            if (n.getFeatureID(Activity.class) == 6) {
                switch (n.getEventType()) {
                    case 4: 
                    case 6: {
                        this.refreshConnections((Activity)n.getNotifier(), "old target(2)", false, true);
                        break;
                    }
                    case 3: 
                    case 5: {
                        this.refreshConnections((Activity)n.getNotifier(), "new target(2)", false, true);
                    }
                }
            }
        }
        if (n.getOldValue() instanceof Activity) {
            this.activityMoved((Activity)n.getOldValue());
        }
        if (n.getNewValue() instanceof Activity) {
            this.activityMoved((Activity)n.getNewValue());
        }
    }

    protected void refreshConnections(Activity activity, String debugRole, boolean refreshSource, boolean refreshTarget) {
        Map registry = this.bpelEditor.getGraphicalViewer().getEditPartRegistry();
        EditPart editPart = (EditPart)registry.get(activity);
        if (editPart instanceof BPELEditPart && editPart.isActive()) {
            System.out.println(String.valueOf(debugRole) + ": " + editPart.getModel());
            if (refreshSource) {
                ((BPELEditPart)editPart).refreshSourceConnections();
            }
            if (refreshTarget) {
                ((BPELEditPart)editPart).refreshTargetConnections();
            }
        }
    }

    protected void refreshConnectionTargets(Sources sources) {
        Map registry = this.bpelEditor.getGraphicalViewer().getEditPartRegistry();
        for (Source source : sources.getChildren()) {
            EditPart targetEditPart;
            Activity targetActivity;
            Link link = source.getLink();
            if (link == null || (targetActivity = FlowLinkUtil.getLinkTarget(link)) == null || !((targetEditPart = (EditPart)registry.get(targetActivity)) instanceof BPELEditPart) || !targetEditPart.isActive()) continue;
            if (this.DEBUG) {
                System.out.println("refreshConnectionTargets on: " + targetEditPart);
            }
            ((BPELEditPart)targetEditPart).refreshTargetConnections();
        }
    }

    protected void refreshConnectionSources(Targets targets) {
        Map registry = this.bpelEditor.getGraphicalViewer().getEditPartRegistry();
        for (Target target : targets.getChildren()) {
            EditPart sourceEditPart;
            Activity sourceActivity;
            Link link = target.getLink();
            if (link == null || (sourceActivity = FlowLinkUtil.getLinkSource(link)) == null || !((sourceEditPart = (EditPart)registry.get(sourceActivity)) instanceof BPELEditPart) || !sourceEditPart.isActive()) continue;
            if (this.DEBUG) {
                System.out.println("refreshConnectionSources on: " + sourceEditPart);
            }
            ((BPELEditPart)sourceEditPart).refreshSourceConnections();
        }
    }

    protected void activityMoved(Activity activity) {
        Map registry = this.bpelEditor.getGraphicalViewer().getEditPartRegistry();
        EditPart editPart = (EditPart)registry.get(activity);
        if (editPart instanceof BPELEditPart && editPart.isActive()) {
            if (this.DEBUG) {
                System.out.println("moved activity: " + editPart.getModel());
            }
            ((BPELEditPart)editPart).refreshSourceConnections();
            ((BPELEditPart)editPart).refreshTargetConnections();
        }
        if (activity.getSources() != null) {
            this.refreshConnectionTargets(activity.getSources());
        }
        if (activity.getTargets() != null) {
            this.refreshConnectionSources(activity.getTargets());
        }
    }
}

