/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Node;

public class XSDComparer {
    protected boolean strict = false;
    protected boolean debug = false;
    protected List<XSDDiagnostic> diagnostics;
    protected Hashtable<XSDTerm, XSDTerm> terms = new Hashtable();

    public void setStrict(boolean flag) {
        this.strict = flag;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    protected boolean alreadyCompared(XSDTerm term1, XSDTerm term2) {
        XSDTerm t = this.terms.get(term1);
        if (t == term2) {
            return true;
        }
        t = this.terms.get(term2);
        return t == term1;
    }

    public boolean compare(XSDTypeDefinition type1, XSDTypeDefinition type2) {
        boolean result;
        block5: {
            result = false;
            if (type1 == null || type2 == null) {
                throw new IllegalArgumentException("XSDComparer: XSD types may not be null");
            }
            try {
                if (this.diagnostics != null) {
                    this.diagnostics.clear();
                }
                if (this.debug || type1 != type2) break block5;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        result = this.compare(this.getChildTerms(type1), this.getChildTerms(type2), 0);
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean compare(List<XSDTerm> list1, List<XSDTerm> list2, int level) {
        XSDTerm term1 = null;
        XSDTerm term2 = null;
        try {
            int index1 = 0;
            int index2 = 0;
            int size1 = list1.size();
            int size2 = list2.size();
            while (index1 < size1 && index2 < size2) {
                term1 = list1.get(index1);
                if (this.alreadyCompared(term1, term2 = list2.get(index2))) {
                    this.dump("Skipping ", term1, null, level);
                } else {
                    this.terms.put(term1, term2);
                    if (term1 instanceof XSDElementDeclaration && term2 instanceof XSDElementDeclaration) {
                        int i;
                        XSDElementDeclaration elem1 = (XSDElementDeclaration)term1;
                        XSDElementDeclaration elem2 = (XSDElementDeclaration)term2;
                        XSDTypeDefinition type1 = elem1.getTypeDefinition();
                        XSDTypeDefinition type2 = elem2.getTypeDefinition();
                        if (type1 instanceof XSDSimpleTypeDefinition && type2 instanceof XSDSimpleTypeDefinition) {
                            String s2;
                            this.dump("Comparing ", (XSDTerm)elem1, type1, level);
                            this.dump("       to ", (XSDTerm)elem2, type2, level);
                            if (!this.compareQNames((XSDNamedComponent)elem1, (XSDNamedComponent)elem2)) {
                                this.addError("different QNames: " + elem1.getQName() + " vs " + elem2.getQName(), (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                return false;
                            }
                            String s1 = this.getTypeNameHierarchy(elem1);
                            if (!s1.equals(s2 = this.getTypeNameHierarchy(elem2))) {
                                this.addError("different data types: " + s1 + " vs " + s2, (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                return false;
                            }
                        } else if (type1 instanceof XSDComplexTypeDefinition && type2 instanceof XSDComplexTypeDefinition) {
                            boolean result;
                            this.dump("Comparing ", (XSDTerm)elem1, type1, level);
                            this.dump("       to ", (XSDTerm)elem2, type2, level);
                            if (!this.compareQNames((XSDNamedComponent)elem1, (XSDNamedComponent)elem2)) {
                                this.addError("different QNames: " + elem1.getQName() + " vs " + elem2.getQName(), (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                return false;
                            }
                            int min1 = this.getMinOccurs(term1);
                            int min2 = this.getMinOccurs(term2);
                            int max1 = this.getMaxOccurs(term1);
                            int max2 = this.getMaxOccurs(term2);
                            if (this.strict) {
                                if (min1 != min2 || max1 != max2) {
                                    this.addError("different cardinality: " + min1 + " to " + max1 + " vs " + min2 + " to " + max2, (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                    return false;
                                }
                            } else if (max2 > 0 && min1 > max2 || max1 > 0 && min2 > max1) {
                                this.addError("incompatible cardinality: " + min1 + " to " + max1 + " vs " + min2 + " to " + max2, (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                return false;
                            }
                            if (!(result = this.compare(this.getChildTerms(elem1), this.getChildTerms(elem2), level + 1))) {
                                this.addError("different complex element structures", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                return false;
                            }
                        } else {
                            if (!this.strict) {
                                ArrayList<XSDTerm> newList2;
                                ArrayList<XSDTerm> newList1;
                                this.dump("Elements out of sync - skipping optional elements");
                                if (this.isOptional((XSDTerm)elem1)) {
                                    newList1 = new ArrayList<XSDTerm>();
                                    newList2 = new ArrayList<XSDTerm>();
                                    i = index1 + 1;
                                    while (i < size1) {
                                        newList1.add(list1.get(i));
                                        ++i;
                                    }
                                    i = index2;
                                    while (i < size2) {
                                        newList2.add(list2.get(i));
                                        ++i;
                                    }
                                    if (this.compare(newList1, newList2, level)) {
                                        this.addWarning("skipped optional element(s) in left schema", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                        return true;
                                    }
                                    this.addError("different complex element structures", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                }
                                if (this.isOptional((XSDTerm)elem2)) {
                                    newList1 = new ArrayList();
                                    newList2 = new ArrayList();
                                    i = index1;
                                    while (i < size1) {
                                        newList1.add(list1.get(i));
                                        ++i;
                                    }
                                    i = index2 + 1;
                                    while (i < size2) {
                                        newList2.add(list2.get(i));
                                        ++i;
                                    }
                                    if (this.compare(newList1, newList2, level)) {
                                        this.addWarning("skipped optional element(s) in right schema", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                        return true;
                                    }
                                    this.addError("different complex element structures", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                }
                            }
                            this.addError("different complex element structures", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                            return false;
                        }
                        List<XSDAttributeDeclaration> attrs1 = this.getAttributeDeclarations(elem1);
                        List<XSDAttributeDeclaration> attrs2 = this.getAttributeDeclarations(elem2);
                        if (attrs1.size() != attrs2.size()) {
                            this.addError("different number of attributes", (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                            return false;
                        }
                        i = 0;
                        while (i < attrs1.size()) {
                            XSDAttributeDeclaration attr1 = attrs1.get(i);
                            XSDAttributeDeclaration attr2 = attrs2.get(i);
                            if (!attr1.getQName().equals(attr2.getQName())) {
                                this.addError("different attribute names: " + attr1.getQName() + " vs " + attr2.getQName(), (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                return false;
                            }
                            String value1 = attr1.getLexicalValue();
                            String value2 = attr2.getLexicalValue();
                            if (value1 == null) {
                                value1 = "";
                            }
                            if (value2 == null) {
                                value2 = "";
                            }
                            if (!value1.equals(value2)) {
                                this.addError("different attribute values: " + attr1.getLexicalValue() + " vs " + attr2.getLexicalValue(), (XSDConcreteComponent)elem1, (XSDConcreteComponent)elem2);
                                return false;
                            }
                            ++i;
                        }
                    } else {
                        ArrayList<XSDTerm> newList2;
                        ArrayList<XSDTerm> newList1;
                        if (term1 instanceof XSDWildcard && !(term2 instanceof XSDWildcard)) {
                            int min = this.getMinOccurs(term1);
                            int max = this.getMinOccurs(term1);
                            if (max == -1) {
                                max = size1;
                            }
                            int n = min;
                            while (n <= max) {
                                newList1 = new ArrayList<XSDTerm>();
                                newList2 = new ArrayList<XSDTerm>();
                                int i = index1 + 1 + n;
                                while (i < size1) {
                                    newList1.add(list1.get(i));
                                    ++i;
                                }
                                i = index2;
                                while (i < size2) {
                                    newList2.add(list2.get(i));
                                    ++i;
                                }
                                if (this.compare(newList1, newList2, level)) {
                                    this.addWarning("skipped optional element(s) in left schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                    return true;
                                }
                                ++n;
                            }
                            this.addError("different complex element structures", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                            return false;
                        }
                        if (term1 instanceof XSDWildcard && !(term2 instanceof XSDWildcard)) {
                            int min = this.getMinOccurs(term2);
                            int max = this.getMinOccurs(term2);
                            if (max == -1) {
                                max = size2;
                            }
                            int n = min;
                            while (n <= max) {
                                newList1 = new ArrayList();
                                newList2 = new ArrayList();
                                int i = index1;
                                while (i < size1) {
                                    newList1.add(list1.get(i));
                                    ++i;
                                }
                                i = index2 + 1 + n;
                                while (i < size2) {
                                    newList2.add(list2.get(i));
                                    ++i;
                                }
                                if (this.compare(newList1, newList2, level)) {
                                    this.addWarning("skipped optional element(s) in right schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                                    return true;
                                }
                                ++n;
                            }
                            this.addError("different complex element structures", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                            return false;
                        }
                        if (term1 instanceof XSDWildcard && term2 instanceof XSDWildcard) {
                            int min1 = this.getMinOccurs(term1);
                            int max1 = this.getMinOccurs(term1);
                            int min2 = this.getMinOccurs(term2);
                            int max2 = this.getMinOccurs(term2);
                            if (min1 != min2 || max1 != max2) {
                                this.addError("different <xsd:any> cardinality: " + min1 + " to " + max1 + " vs " + min2 + " to " + max2, (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                            }
                        }
                    }
                }
                ++index1;
                ++index2;
            }
            if (this.strict && size1 != size2) {
                this.addError("different number of elements: " + size1 + " vs " + size2, (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                return false;
            }
            if (index1 < size1) {
                this.dump("Additional elements in left schema");
                while (index1 < size1) {
                    term1 = list1.get(index1);
                    if (this.isOptional(term1)) {
                        this.dump("Ignoring optional element", term1, null, 1);
                        this.addWarning("skipped optional element in left schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                        term1 = list2.get(++index1);
                        continue;
                    }
                    this.addError("additional elements in left schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                    return false;
                }
            }
            if (index2 < size2) {
                this.dump("Additional elements in right schema");
                while (index2 < size2) {
                    term2 = list2.get(index2);
                    if (this.isOptional(term2)) {
                        this.dump("Ignoring optional element", term2, null, 1);
                        this.addWarning("skipped optional element in right schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                        term2 = list2.get(++index2);
                        continue;
                    }
                    this.addError("additional elements in right schema", (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.addError("caught exception: " + e.toString(), (XSDConcreteComponent)term1, (XSDConcreteComponent)term2);
            e.printStackTrace();
            return false;
        }
        if (level == 0) {
            this.dump("*** Schemas are compatible");
        }
        return true;
    }

    protected String getTypeNameHierarchy(XSDElementDeclaration elem) {
        String s = "";
        Stack<String> names = new Stack<String>();
        XSDTypeDefinition type = elem.getType();
        while (type != type.getBaseType()) {
            String name = type.getName();
            if (name != null) {
                names.push(name);
            }
            type = type.getBaseType();
        }
        while (!names.isEmpty()) {
            s = s.isEmpty() ? (String)names.pop() : String.valueOf(s) + ":" + (String)names.pop();
        }
        return s;
    }

    private boolean compareQNames(XSDNamedComponent elem1, XSDNamedComponent elem2) {
        String name1 = elem1.getName();
        String name2 = elem2.getName();
        if (name1 == null || name2 == null) {
            return name1 == name2;
        }
        if (name1.equals(name2)) {
            if (elem1.getTargetNamespace() == null || elem1.getTargetNamespace().isEmpty() && elem2.getTargetNamespace() == null || elem2.getTargetNamespace().isEmpty()) {
                return true;
            }
            if (elem1.getTargetNamespace().equals(elem2.getTargetNamespace())) {
                return true;
            }
            if (elem1.getSchema().getTargetNamespace().equals(elem2.getSchema().getTargetNamespace())) {
                return true;
            }
        }
        return false;
    }

    protected final List<XSDTerm> getChildTerms(XSDElementDeclaration element) {
        return this.getChildTerms(element.getType());
    }

    protected final List<XSDTerm> getChildTerms(XSDTypeDefinition type) {
        final ArrayList<XSDTerm> terms = new ArrayList<XSDTerm>();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                XSDComparer.this.visitTerms(cType, new TermVisitor(){

                    @Override
                    public void visit(XSDParticle particle) {
                        XSDParticleContent content = particle.getContent();
                        if (content instanceof XSDElementDeclaration) {
                            XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                            if (decl.isElementDeclarationReference()) {
                                decl = decl.getResolvedElementDeclaration();
                            }
                            terms.add(decl);
                        } else if (content instanceof XSDWildcard) {
                            terms.add((XSDWildcard)content);
                        }
                    }
                });
                return true;
            }
        };
        TypeWalker walker = new TypeWalker(type);
        walker.walk(visitor);
        return terms;
    }

    public int getMinOccurs(XSDTerm term) {
        String smin = term.getElement().getAttribute("minOccurs");
        int min = 1;
        if (smin != null && !smin.isEmpty()) {
            try {
                min = Integer.parseInt(smin);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return min;
    }

    public int getMaxOccurs(XSDTerm term) {
        int max;
        block3: {
            String smax = term.getElement().getAttribute("maxOccurs");
            max = 1;
            if (smax != null && !smax.isEmpty()) {
                try {
                    max = Integer.parseInt(smax);
                }
                catch (NumberFormatException e) {
                    if (!smax.equalsIgnoreCase("unbounded")) break block3;
                    max = -1;
                }
            }
        }
        return max;
    }

    protected boolean isOptional(XSDTerm term) {
        return this.getMinOccurs(term) == 0;
    }

    private void visitTerms(XSDComplexTypeDefinition cType, TermVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        XSDParticleContent lastVisited = null;
        LinkedList<XSDParticle> queue = new LinkedList<XSDParticle>();
        queue.addLast((XSDParticle)cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 11) {
                lastVisited = particle.getContent();
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup modelGroup = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    modelGroup = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    modelGroup = (XSDModelGroup)particle.getContent();
                    break;
                }
                case 2: {
                    if (lastVisited == null) break;
                    lastVisited = particle.getContent();
                    visitor.visit(particle);
                    break;
                }
            }
            if (modelGroup == null) continue;
            EList particles = modelGroup.getParticles();
            for (XSDParticle p : particles) {
                queue.addLast(p);
            }
            lastVisited = null;
        }
    }

    public final List<XSDAttributeDeclaration> getAttributeDeclarations(XSDElementDeclaration element) {
        final ArrayList<XSDAttributeDeclaration> attributes = new ArrayList<XSDAttributeDeclaration>();
        TypeWalker walker = new TypeWalker(element.getType());
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                EList contents = cType.getAttributeContents();
                for (XSDAttributeGroupContent content : contents) {
                    if (content instanceof XSDAttributeUse) {
                        XSDAttributeUse use = (XSDAttributeUse)content;
                        attributes.add(use.getAttributeDeclaration());
                        continue;
                    }
                    if (!(content instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition attGrp = (XSDAttributeGroupDefinition)content;
                    if (attGrp.isAttributeGroupDefinitionReference()) {
                        attGrp = attGrp.getResolvedAttributeGroupDefinition();
                    }
                    EList uses = attGrp.getAttributeUses();
                    for (XSDAttributeUse use : uses) {
                        attributes.add(use.getAttributeDeclaration());
                    }
                }
                return true;
            }
        };
        walker.walk(visitor);
        return attributes;
    }

    public List<XSDDiagnostic> getDiagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList<XSDDiagnostic>();
        }
        return this.diagnostics;
    }

    public String getDiagnostic(int index) {
        String msg = "";
        if (this.diagnostics != null && index >= 0 && index < this.diagnostics.size()) {
            XSDDiagnostic d = this.diagnostics.get(index);
            String name1 = "";
            String name2 = "";
            String schema1 = "";
            String schema2 = "";
            XSDTerm comp1 = null;
            XSDTerm comp2 = null;
            EList components = d.getComponents();
            if (components.size() > 0 && components.get(0) instanceof XSDTerm) {
                comp1 = (XSDTerm)components.get(0);
            }
            if (components.size() > 1 && components.get(1) instanceof XSDTerm) {
                comp2 = (XSDTerm)components.get(1);
            }
            if (comp1 instanceof XSDElementDeclaration) {
                name1 = ((XSDElementDeclaration)comp1).getQName();
                schema1 = comp1.eResource().getURI().toString();
            } else if (comp1 instanceof XSDWildcard) {
                name1 = "<xsd:any>";
                schema1 = comp1.eResource().getURI().toString();
            }
            if (comp2 instanceof XSDElementDeclaration) {
                name2 = ((XSDElementDeclaration)comp2).getQName();
                schema2 = comp2.eResource().getURI().toString();
            } else if (comp2 instanceof XSDWildcard) {
                name2 = "<xsd:any>";
                schema2 = comp2.eResource().getURI().toString();
            }
            if (comp1 != null && comp2 != null) {
                msg = "Element <" + name1 + ">" + " in " + schema1 + " differs from <" + name2 + ">";
                if (!schema1.equals(schema2)) {
                    msg = String.valueOf(msg) + " in " + schema2;
                }
                msg = String.valueOf(msg) + " - " + d.getMessage();
            } else {
                msg = "Schema " + d.getLocationURI() + " - " + d.getMessage();
            }
        }
        return msg;
    }

    protected XSDDiagnostic addDiagnostic(int severity, String msg, XSDConcreteComponent comp1, XSDConcreteComponent comp2) {
        XSDDiagnostic diag = XSDFactory.eINSTANCE.createXSDDiagnostic();
        diag.setSeverity(XSDDiagnosticSeverity.get((int)severity));
        diag.setMessage(msg);
        diag.getComponents().add((Object)comp1);
        diag.getComponents().add((Object)comp2);
        this.getDiagnostics().add(diag);
        if (this.debug) {
            this.dump(this.getDiagnostic(this.getDiagnostics().size() - 1));
        }
        return diag;
    }

    protected XSDDiagnostic addWarning(String msg, XSDConcreteComponent comp1, XSDConcreteComponent comp2) {
        return this.addDiagnostic(2, msg, comp1, comp2);
    }

    protected XSDDiagnostic addError(String msg, XSDConcreteComponent comp1, XSDConcreteComponent comp2) {
        return this.addDiagnostic(1, msg, comp1, comp2);
    }

    private void dump(String label) {
        if (this.debug) {
            this.dump(label, null, null, 0);
        }
    }

    private void dump(String label, XSDTerm term, XSDTypeDefinition type, int level) {
        if (this.debug) {
            if (term != null) {
                StringBuilder indent = new StringBuilder();
                int i = 0;
                while (i < level) {
                    indent.append("    ");
                    ++i;
                }
                if (term instanceof XSDElementDeclaration) {
                    XSDElementDeclaration decl = (XSDElementDeclaration)term;
                    if (type instanceof XSDSimpleTypeDefinition) {
                        System.err.println(String.valueOf(label) + indent + "<" + decl.getName() + "> type=\"" + this.getTypeNameHierarchy(decl) + "\"");
                    } else if (type instanceof XSDComplexTypeDefinition || type == null) {
                        System.err.println(String.valueOf(label) + indent + "<" + decl.getName() + ">");
                    } else {
                        System.err.println("dump: unknown XSD type: " + type.getClass().toString());
                    }
                } else if (term instanceof XSDWildcard) {
                    System.err.println(String.valueOf(label) + indent + "<any/>");
                } else {
                    System.err.println("dump: unknown term: " + term.getClass().toString());
                }
            } else {
                System.err.println(label);
            }
        }
    }

    private static interface TermVisitor {
        public void visit(XSDParticle var1);
    }

    private static class TypeWalker {
        XSDTypeDefinition base;

        public TypeWalker(XSDTypeDefinition base) {
            this.base = base;
        }

        public void walk(Visitor visitor) {
            XSDTypeDefinition type = this.base;
            while (type != null) {
                if (!visitor.visit(type) || type.equals(type.getBaseType())) break;
                type = type.getBaseType();
            }
        }

        public static interface Visitor {
            public boolean visit(XSDTypeDefinition var1);
        }
    }

    private static class XSDTermTuple {
        public XSDTerm term1;
        public XSDTerm term2;

        public XSDTermTuple(XSDTerm term1, XSDTerm term2) {
            this.term1 = term1;
            this.term2 = term2;
        }
    }
}

