/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model;

import java.text.MessageFormat;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.model.adapters.BasicBPELAdapterFactory;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.common.util.ResourceLocator;

public class BPELPlugin
extends EMFPlugin {
    public static final BPELPlugin INSTANCE = new BPELPlugin();
    public static final String PLUGIN_ID = "org.eclipse.bpel.model";
    private static Implementation plugin;

    public BPELPlugin() {
        super(new ResourceLocator[0]);
        AdapterRegistry.INSTANCE.registerAdapterFactory(BPELPackage.eINSTANCE, (AdapterFactory)BasicBPELAdapterFactory.INSTANCE);
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void logMessage(String message, Throwable e, int severity) {
        Status status = new Status(severity, PLUGIN_ID, 0, message, e);
        Logger logger = INSTANCE.getPluginLogger();
        logger.log((Object)status);
    }

    public static void log(String message, Throwable e, int severity) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String m;
            String string = m = e != null ? e.getMessage() : null;
            if (message == null) {
                if (m == null) {
                    m = "<no message>";
                }
            } else {
                m = m == null ? message : String.valueOf(message) + "[" + m + "]";
            }
            status = new Status(severity, PLUGIN_ID, 0, m, e);
        }
        Logger logger = INSTANCE.getPluginLogger();
        if (logger != null) {
            logger.log((Object)status);
        } else if (Platform.isRunning()) {
            RuntimeLog.log((IStatus)status);
        } else {
            String msg = MessageFormat.format("{1,choice,0#msg|1#Info|2#Warning|4#Error}@{0}: {3}", status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage());
            System.err.println(msg);
            if (status.getException() != null) {
                status.getException().printStackTrace(System.err);
            }
        }
    }

    public static void log(String message, Throwable e) {
        BPELPlugin.log(message, e, 4);
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public static IWorkspace getWorkspace() {
            return ResourcesPlugin.getWorkspace();
        }
    }
}

