/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.SftpSubsystemProxy;

public interface SftpFileSystemAccessor {
    public static final List<String> DEFAULT_UNIX_VIEW = Collections.singletonList("unix:*");
    public static final NavigableMap<String, FileInfoExtractor<?>> FILEATTRS_RESOLVERS = MapEntryUtils.NavigableMapBuilder.builder((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)"isRegularFile", (Object)FileInfoExtractor.ISREG).put((Object)"isDirectory", (Object)FileInfoExtractor.ISDIR).put((Object)"isSymbolicLink", (Object)FileInfoExtractor.ISSYMLINK).put((Object)"permissions", (Object)FileInfoExtractor.PERMISSIONS).put((Object)"size", (Object)FileInfoExtractor.SIZE).put((Object)"lastModifiedTime", (Object)FileInfoExtractor.LASTMODIFIED).immutable();
    public static final String PROP_AUTO_SYNC_FILE_ON_CLOSE = "sftp-auto-fsync-on-close";
    public static final boolean DEFAULT_AUTO_SYNC_FILE_ON_CLOSE = true;
    public static final SftpFileSystemAccessor DEFAULT = new SftpFileSystemAccessor(){

        public String toString() {
            return SftpFileSystemAccessor.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public Path resolveLocalFilePath(ServerSession session, SftpSubsystemProxy subsystem, Path rootDir, String remotePath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath((String)remotePath, (char)'/', (FileSystem)rootDir.getFileSystem());
        return rootDir.resolve(path);
    }

    default public SeekableByteChannel openFile(ServerSession session, SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            attrs = IoUtils.EMPTY_FILE_ATTRIBUTES;
        }
        return FileChannel.open(file, options, attrs);
    }

    default public FileLock tryLock(ServerSession session, SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, long position, long size, boolean shared) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to lock: " + channel);
        }
        return ((FileChannel)channel).lock(position, size, shared);
    }

    default public void syncFileData(ServerSession session, SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to sync: " + channel);
        }
        ((FileChannel)channel).force(true);
    }

    default public void closeFile(ServerSession session, SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, Set<? extends OpenOption> options) throws IOException {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (channel instanceof FileChannel && GenericUtils.containsAny(options, (Iterable)IoUtils.WRITEABLE_OPEN_OPTIONS) && PropertyResolverUtils.getBooleanProperty((PropertyResolver)session, (String)PROP_AUTO_SYNC_FILE_ON_CLOSE, (boolean)true)) {
            ((FileChannel)channel).force(true);
        }
        channel.close();
    }

    default public DirectoryStream<Path> openDirectory(ServerSession session, SftpSubsystemProxy subsystem, DirectoryHandle dirHandle, Path dir, String handle) throws IOException {
        return Files.newDirectoryStream(dir);
    }

    default public void closeDirectory(ServerSession session, SftpSubsystemProxy subsystem, DirectoryHandle dirHandle, Path dir, String handle, DirectoryStream<Path> ds) throws IOException {
        if (ds == null) {
            return;
        }
        ds.close();
    }

    default public Map<String, ?> readFileAttributes(ServerSession session, SftpSubsystemProxy subsystem, Path file, String view, LinkOption ... options) throws IOException {
        return Files.readAttributes(file, view, options);
    }

    default public void setFileAttribute(ServerSession session, SftpSubsystemProxy subsystem, Path file, String view, String attribute, Object value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        Files.setAttribute(file, view + ":" + attribute, value, options);
    }

    default public UserPrincipal resolveFileOwner(ServerSession session, SftpSubsystemProxy subsystem, Path file, UserPrincipal name) throws IOException {
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        String username = name.toString();
        if (lookupService == null) {
            throw new UserPrincipalNotFoundException(username);
        }
        return lookupService.lookupPrincipalByName(username);
    }

    default public void setFileOwner(ServerSession session, SftpSubsystemProxy subsystem, Path file, Principal value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        FileOwnerAttributeView view = Files.getFileAttributeView(file, FileOwnerAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("Owner view not supported for " + file);
        }
        if (!(value instanceof UserPrincipal)) {
            throw new StreamCorruptedException("Owner is not " + UserPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
        }
        view.setOwner((UserPrincipal)value);
    }

    default public GroupPrincipal resolveGroupOwner(ServerSession session, SftpSubsystemProxy subsystem, Path file, GroupPrincipal name) throws IOException {
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        String groupName = name.toString();
        if (lookupService == null) {
            throw new UserPrincipalNotFoundException(groupName);
        }
        return lookupService.lookupPrincipalByGroupName(groupName);
    }

    default public void setGroupOwner(ServerSession session, SftpSubsystemProxy subsystem, Path file, Principal value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("POSIX view not supported");
        }
        if (!(value instanceof GroupPrincipal)) {
            throw new StreamCorruptedException("Group is not " + GroupPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
        }
        view.setGroup((GroupPrincipal)value);
    }

    default public void setFilePermissions(ServerSession session, SftpSubsystemProxy subsystem, Path file, Set<PosixFilePermission> perms, LinkOption ... options) throws IOException {
        if (OsUtils.isWin32()) {
            IoUtils.setPermissionsToFile((File)file.toFile(), perms);
            return;
        }
        PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("POSIX view not supported for " + file);
        }
        view.setPermissions(perms);
    }

    default public void setFileAccessControl(ServerSession session, SftpSubsystemProxy subsystem, Path file, List<AclEntry> acl, LinkOption ... options) throws IOException {
        AclFileAttributeView view = Files.getFileAttributeView(file, AclFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("ACL view not supported for " + file);
        }
        view.setAcl(acl);
    }

    default public void createDirectory(ServerSession session, SftpSubsystemProxy subsystem, Path path) throws IOException {
        Files.createDirectory(path, new FileAttribute[0]);
    }

    default public void createLink(ServerSession session, SftpSubsystemProxy subsystem, Path link, Path existing, boolean symLink) throws IOException {
        if (symLink) {
            Files.createSymbolicLink(link, existing, new FileAttribute[0]);
        } else {
            Files.createLink(link, existing);
        }
    }

    default public String resolveLinkTarget(ServerSession session, SftpSubsystemProxy subsystem, Path link) throws IOException {
        Path target = Files.readSymbolicLink(link);
        return target.toString();
    }

    default public void renameFile(ServerSession session, SftpSubsystemProxy subsystem, Path oldPath, Path newPath, Collection<CopyOption> opts) throws IOException {
        Files.move(oldPath, newPath, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    default public void copyFile(ServerSession session, SftpSubsystemProxy subsystem, Path src, Path dst, Collection<CopyOption> opts) throws IOException {
        Files.copy(src, dst, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    default public void removeFile(ServerSession session, SftpSubsystemProxy subsystem, Path path, boolean isDirectory) throws IOException {
        Files.delete(path);
    }
}

