/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public class SearchPlan {
    private final List<ISearchOperation> operations;
    private final Map<Integer, PVariable> variableMapping;
    private final TupleMask parameterMask;
    private final PBody body;

    public SearchPlan(PBody body, List<ISearchOperation> operations, TupleMask parameterMask, Map<PVariable, Integer> variableMapping) {
        this.body = body;
        this.operations = Collections.unmodifiableList(new ArrayList<ISearchOperation>(operations));
        this.parameterMask = parameterMask;
        this.variableMapping = Collections.unmodifiableMap(variableMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }

    public List<ISearchOperation> getOperations() {
        return this.operations;
    }

    public Map<Integer, PVariable> getVariableMapping() {
        return this.variableMapping;
    }

    public int getOperationIndex(ISearchOperation operation) {
        return this.operations.indexOf(operation);
    }

    public TupleMask getParameterMask() {
        return this.parameterMask;
    }

    public PBody getSourceBody() {
        return this.body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (ISearchOperation operation : this.getOperations()) {
            sb.append("\t");
            sb.append(operation);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

