/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlElementWrapper
extends AbstractJavaContextNode
implements XmlElementWrapper {
    protected final Context context;
    protected JaxbQName qName;
    protected Boolean specifiedRequired;
    protected Boolean specifiedNillable;

    public GenericJavaXmlElementWrapper(JavaAttributeMapping parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.specifiedNillable = this.buildSpecifiedNillable();
    }

    protected JaxbQName buildQName() {
        return new XmlElementQName(this);
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.getParent();
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    protected XmlElementWrapperAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setSpecifiedNillable_(this.buildSpecifiedNillable());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public boolean isRequired() {
        return this.getSpecifiedRequired() == null ? this.isDefaultRequired() : this.getSpecifiedRequired().booleanValue();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation().setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        return this.getAnnotation().getRequired();
    }

    @Override
    public boolean isNillable() {
        return this.getSpecifiedNillable() == null ? this.isDefaultNillable() : this.getSpecifiedNillable().booleanValue();
    }

    @Override
    public boolean isDefaultNillable() {
        return false;
    }

    @Override
    public Boolean getSpecifiedNillable() {
        return this.specifiedNillable;
    }

    @Override
    public void setSpecifiedNillable(Boolean newSpecifiedNillable) {
        this.getAnnotation().setNillable(newSpecifiedNillable);
        this.setSpecifiedNillable_(newSpecifiedNillable);
    }

    protected void setSpecifiedNillable_(Boolean newSpecifiedNillable) {
        Boolean oldNillable = this.specifiedNillable;
        this.specifiedNillable = newSpecifiedNillable;
        this.firePropertyChanged("specifiedNillable", oldNillable, newSpecifiedNillable);
    }

    protected Boolean buildSpecifiedNillable() {
        return this.getAnnotation().getNillable();
    }

    @Override
    public XsdElementDeclaration getXsdElementDeclaration() {
        XsdTypeDefinition xsdType = this.getPersistentAttribute().getClassMapping().getXsdTypeDefinition();
        return xsdType == null ? null : xsdType.getElement(this.qName.getNamespace(), this.qName.getName());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (!this.getPersistentAttribute().isJavaResourceAttributeCollectionType() && !this.getPersistentAttribute().isJavaResourceAttributeTypeSubTypeOf(Map.class.getName())) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_WRAPPER_DEFINED_ON_NON_ARRAY_NON_COLLECTION));
        }
        this.validateQName(messages, reporter);
    }

    protected void validateQName(List<IMessage> messages, IReporter reporter) {
        this.qName.validate(messages, reporter);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    public static interface Context {
        public XmlElementWrapperAnnotation getAnnotation();
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        @Override
        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElementWrapper.this.getAnnotation();
        }
    }

    public static class SimpleContext
    implements Context {
        protected XmlElementWrapperAnnotation annotation;

        public SimpleContext(XmlElementWrapperAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public XmlElementWrapperAnnotation getAnnotation() {
            return this.annotation;
        }
    }

    protected class XmlElementQName
    extends AbstractQName {
        protected XmlElementQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaXmlElementWrapper.this.getJaxbPackage();
        }

        @Override
        protected String buildDefaultName() {
            return GenericJavaXmlElementWrapper.this.getPersistentAttribute().getJavaResourceAttribute().getName();
        }

        @Override
        protected String buildDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage != null && jaxbPackage.getElementFormDefault() == XmlNsForm.QUALIFIED ? GenericJavaXmlElementWrapper.this.getClassMapping().getQName().getNamespace() : "";
        }

        @Override
        public Iterable<String> getNameProposals() {
            XsdTypeDefinition xsdType = GenericJavaXmlElementWrapper.this.getClassMapping().getXsdTypeDefinition();
            return xsdType == null ? EmptyIterable.instance() : xsdType.getElementNameProposals(this.getNamespace());
        }

        @Override
        public Iterable<String> getNamespaceProposals() {
            XsdSchema schema = this.getXsdSchema();
            return schema == null ? EmptyIterable.instance() : schema.getNamespaceProposals();
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_ELEMENT_DESC;
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            XsdTypeDefinition type = GenericJavaXmlElementWrapper.this.getClassMapping().getXsdTypeDefinition();
            if (type == null) {
                return;
            }
            if (type.getElement(this.getNamespace(), this.getName()) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage());
            }
        }
    }
}

